/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.net.Socket;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.network.AbstractNetworkService;
import jeus.security.impl.network.ServerSecurityConnectionListener;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.JeusSecurityProperties;
import jeus.util.EnvironmentCall;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;

public class StandaloneServerSocketNetworkService
extends AbstractNetworkService
implements ConnectionListenerFactory {
    private boolean enableNIO = true;
    private static final String THREAD_NAME_PREFIX = "SecurityNetworkService";
    private int threadPoolMinSize = 10;
    private int threadPoolMaxSize = 20;
    private long threadPoolResizePeriod = 60000L;
    private static Executor pooledExecutor;
    protected static final JeusLogger logger;

    protected void doCreate() throws ServiceException {
        String poolsize;
        Environment localEnv = SecurityInstaller.getEnvironment();
        this.enableNIO = localEnv.enableNIO;
        if (logger.isLoggable(JeusMessage_Security._5_LEVEL)) {
            logger.log(JeusMessage_Security._5_LEVEL, JeusMessage_Security._5, (Object)String.valueOf(this.enableNIO));
        }
        this.threadPoolMaxSize = (poolsize = this.getProperty("threadpool")) == null || poolsize.equals("") ? 5 : Integer.parseInt(poolsize);
        if (this.threadPoolMaxSize <= 0) {
            this.threadPoolMaxSize = 5;
        }
        try {
            SSLContext sslContext;
            NodeInfo nodeInfo;
            pooledExecutor = PooledExecutorFactory.createPooledExecutor((String)THREAD_NAME_PREFIX, (int)this.threadPoolMaxSize);
            if (JeusSecurityProperties.USE_SSL) {
                nodeInfo = new NodeInfo(EnvironmentCall.getLocalFullHostName(), EnvironmentCall.getSecuritySSLPort(), 0);
                sslContext = EnvironmentCall.getSecuritySSLContext((boolean)JeusSecurityProperties.USE_SSL);
            } else {
                nodeInfo = new NodeInfo(EnvironmentCall.getLocalFullHostName(), localEnv.baseSecurityPort, EnvironmentCall.getSecurityID(), 0);
                sslContext = null;
            }
            this.endpoint = new Endpoint("ServerSecurity", EnvironmentCall.getSecurityIOComponent((String)"ServerSecurity", (int)0, (boolean)this.enableNIO), (SocketID)nodeInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), (ConnectionListenerFactory)this, (Object)sslContext);
            this.endpoint.export();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to create ServerSocketNetworkService: unexpected exception occured", e);
        }
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new ServerSecurityConnectionListener(this, pooledExecutor);
    }

    public static Executor getPooledExecutor() {
        return pooledExecutor;
    }

    protected boolean loginSubject(NetworkMessage message, boolean loggedIn) throws ServiceException, SecurityException {
        LoginService.login(message.getSubject());
        loggedIn = true;
        return loggedIn;
    }

    protected Object processException(Exception e) {
        e.printStackTrace();
        return e;
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.security");
    }
}

