/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.verification;

import javax.management.ObjectName;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.CustomPasswordFactory;
import jeus.security.resource.Password;
import jeus.security.spi.CredentialVerificationService;
import jeus.security.util.InstanceMaker;

public class CustomPasswordVerificationService
extends CredentialVerificationService {
    private CredentialFactory credFactory;
    private Password passwordImpl;
    private String passwordPropertyKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doVerifyCredentials(Subject refSub, Subject proofSub) throws ServiceException, SecurityException {
        for (Password ref : refSub.getPrivateCredentials()) {
            CredentialFactory credentialFactory = this.credFactory;
            synchronized (credentialFactory) {
                ((CustomPasswordFactory)this.credFactory).setPassword(ref.getPassword());
                try {
                    ref = (Password)this.credFactory.getCredential();
                }
                catch (CredentialFactoryException cfe) {
                    this.credFactory.setProperty(this.passwordPropertyKey, "");
                    continue;
                    catch (Throwable throwable) {
                        this.credFactory.setProperty(this.passwordPropertyKey, "");
                        throw throwable;
                    }
                }
                this.credFactory.setProperty(this.passwordPropertyKey, "");
            }
            for (Password proof : proofSub.getPrivateCredentials()) {
                if (!ref.implies(proof)) continue;
                return;
            }
        }
        throw new SecurityException();
    }

    protected boolean handles(Subject refSubject, Subject proofSubject) {
        return refSubject != null && refSubject.getPrivateCredentials(Password.class).size() > 0 && proofSubject != null && proofSubject.getPrivateCredentials(Password.class).size() > 0;
    }

    protected void doCreate() throws ServiceException, SecurityException {
        String hashAlgorithm = this.getProperty("hash-algorithm", "none");
        String encoding = this.getProperty("encoding", "base64");
        String hashCharset = this.getProperty("hash-charset");
        String cfClazz = this.getProperty("credential-factory-classname", "jeus.security.resource.CustomPasswordFactory");
        this.passwordPropertyKey = this.getProperty("password-keyname", "password");
        try {
            this.credFactory = (CredentialFactory)InstanceMaker.makeInstance(cfClazz, null);
            this.credFactory.setProperty("hash-algorithm", hashAlgorithm);
            this.credFactory.setProperty("encoding", encoding);
            if (hashCharset != null && !hashCharset.equals("")) {
                this.credFactory.setProperty("hash-charset", hashCharset);
            }
        }
        catch (Exception e) {
            throw (ServiceException)e;
        }
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }
}

