/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.verification;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.management.ObjectName;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.Certificate;
import jeus.security.spi.CredentialVerificationService;

public class SunCertificateVerificationService
extends CredentialVerificationService {
    protected void doCreate() throws ServiceException, SecurityException {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected boolean handles(Subject refSubject, Subject proofSubject) {
        return proofSubject != null && proofSubject.getPublicCredentials(Certificate.class).size() > 0;
    }

    protected void doVerifyCredentials(Subject refSub, Subject proofSub) throws ServiceException, SecurityException {
        for (X509Certificate cert : proofSub.getPublicCredentials()) {
            if (!this.compareX509Certificate(refSub, cert)) continue;
            return;
        }
        throw new SecurityException();
    }

    private boolean compareX509Certificate(Subject refSub, X509Certificate cert) {
        for (X509Certificate refCert : refSub.getCredentials(X509Certificate.class)) {
            block4: {
                try {
                    if (!this.compareBinary(refCert, cert)) break block4;
                    cert.verify(refCert.getPublicKey());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            return true;
        }
        return false;
    }

    private boolean compareBinary(X509Certificate refCert, X509Certificate cert) throws IOException {
        ByteArrayOutputStream bytesOutputRef = new ByteArrayOutputStream(4096);
        ObjectOutputStream outputRef = new ObjectOutputStream(bytesOutputRef);
        outputRef.writeObject(refCert);
        outputRef.flush();
        outputRef.close();
        byte[] refCertBytes = bytesOutputRef.toByteArray();
        ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(4096);
        ObjectOutputStream output = new ObjectOutputStream(bytesOutput);
        output.writeObject(cert);
        output.flush();
        output.close();
        byte[] certBytes = bytesOutput.toByteArray();
        if (refCertBytes.length != certBytes.length) {
            return false;
        }
        for (int i = 0; i < certBytes.length; ++i) {
            if (refCertBytes[i] == certBytes[i]) continue;
            return false;
        }
        return true;
    }
}

