/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.verification;

import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.management.ObjectName;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.CredentialVerificationService;
import jeus.security.util.LoggerUtil;

public class X509CertificateVerificationService
extends CredentialVerificationService {
    protected void doCreate() throws ServiceException, SecurityException {
    }

    protected void doDestroy() {
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected boolean handles(Subject refSubject, Subject proofSubject) {
        return proofSubject != null && proofSubject.getPublicCredentials(X509Certificate.class).size() > 0;
    }

    protected void doVerifyCredentials(Subject refSub, Subject proofSub) throws ServiceException, SecurityException {
        for (X509Certificate cert : proofSub.getPublicCredentials(X509Certificate.class)) {
            if (LoggerUtil.logger.isLoggable(Level.FINE)) {
                LoggerUtil.logger.log(Level.FINE, " Checking validity for '" + cert.getSubjectDN().getName() + "'");
            }
            try {
                cert.checkValidity();
            }
            catch (Exception e) {
                new SecurityException(e.getMessage());
            }
        }
    }
}

