/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import jeus.security.util.Arrays;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class Certificate
implements Serializable {
    static final long serialVersionUID = 5985260746365850018L;
    private long timeStamp;
    private byte[] cipher;
    private String algorithm;
    private java.security.cert.Certificate cert;
    private transient PrivateKey privateKey;
    private String trustStore;
    private String alias;

    public Certificate() {
    }

    public Certificate(java.security.cert.Certificate cert, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.algorithm = privateKey.getAlgorithm();
        this.cert = cert;
    }

    public Certificate(String algorithm, String trustStore, String alias) {
        this.algorithm = algorithm;
        this.trustStore = trustStore;
        this.alias = alias;
    }

    public boolean verify() {
        try {
            this.cert.verify(this.cert.getPublicKey());
            if (this.privateKey != null) {
                this.timeStamp = System.currentTimeMillis();
                this.cipher = this.getCipher(this.timeStamp);
            }
            Cipher ciph = Cipher.getInstance(this.algorithm);
            ciph.init(2, this.cert.getPublicKey());
            byte[] plaintext = ciph.doFinal(this.cipher);
            return Arrays.compareByteArrays(plaintext, Long.toString(this.timeStamp).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized byte[] getCipher(long timeStamp) {
        try {
            if (this.privateKey == null) {
                return null;
            }
            Cipher ciph = Cipher.getInstance(this.algorithm);
            ciph.init(1, this.privateKey);
            return ciph.doFinal(Long.toString(timeStamp).getBytes());
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._29_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._29_LEVEL, JeusMessage_Security._29, (Throwable)e);
            }
            return null;
        }
    }

    public java.security.cert.Certificate getCertificate() {
        return this.cert;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        this.timeStamp = System.currentTimeMillis();
        this.cipher = this.getCipher(this.timeStamp);
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

