/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.resource.ExpiryTime;

public class ExpiryTimeFactory
extends Properties
implements CredentialFactory {
    public static final String EXPIRY_TIME_PROPERTY_KEY = "expires";

    public ExpiryTimeFactory() {
    }

    public ExpiryTimeFactory(String expiryTime) {
        this.setProperty(EXPIRY_TIME_PROPERTY_KEY, expiryTime);
    }

    public Object getCredential() throws CredentialFactoryException {
        String time = this.getProperty(EXPIRY_TIME_PROPERTY_KEY);
        return new ExpiryTime(this.getLongTime(time));
    }

    public boolean isPublicCredential() {
        return true;
    }

    private long getLongTime(String time) throws CredentialFactoryException {
        if (time == null) {
            throw new CredentialFactoryException("The expires property is null");
        }
        try {
            StringTokenizer st = new StringTokenizer(time, " ");
            int year = Integer.parseInt(st.nextToken());
            int month = Integer.parseInt(st.nextToken()) - 1;
            int day = Integer.parseInt(st.nextToken());
            int hour = Integer.parseInt(st.nextToken());
            int minute = Integer.parseInt(st.nextToken());
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(year, month, day, hour, minute);
            return c.getTimeInMillis();
        }
        catch (Throwable t) {
            throw new CredentialFactoryException("Error while parsing expiry time string", t);
        }
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof ExpiryTimeFactory)) {
            return false;
        }
        return super.equals(another);
    }
}

