/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.GroupNotExistsException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectNotExistsException;
import jeus.security.util.EnumerationUtil;

public abstract class AuthenticationRepositoryService
extends Service {
    public static final String SUBJECT_ADDED_EVENT_TYPE = "security.authentication.repository.subject.added";
    public static final String SUBJECT_REMOVED_EVENT_TYPE = "security.authentication.repository.subject.removed";
    public static final String SUBJECT_REMOVED_COMPLETE_EVENT_TYPE = "security.authentication.repository.subject.removed.complete";
    public static final String SUBJECT_SAVED_EVENT_TYPE = "security.authentication.repository.subject.saved";
    public static final String GROUP_ADDED_EVENT_TYPE = "security.authentication.repository.group.added";
    public static final String GROUP_ADDED_USER_EVENT_TYPE = "security.authentication.repository.group.added.user";
    public static final String GROUP_REMOVED_EVENT_TYPE = "security.authentication.repository.group.removed";
    public static final String GROUP_SAVED_EVENT_TYPE = "security.authentication.repository.group.saved";
    public static final ResourcePermission GET_SUBJECT_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "getSubject");
    public static final ResourcePermission ADD_SUBJECT_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "addSubject");
    public static final ResourcePermission REMOVE_SUBJECT_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "removeSubject");
    public static final ResourcePermission GET_GROUP_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "getGroup");
    public static final ResourcePermission GET_GROUP_LIST_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "getGroupList");
    public static final ResourcePermission ADD_GROUP_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "addGroup");
    public static final ResourcePermission ADD_USER_TO_GROUP_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "addUserToGroup");
    public static final ResourcePermission REMOVE_GROUP_PERMISSION = new ResourcePermission(AuthenticationRepositoryService.class.getName(), "removeGroup");

    public static Subject getSubject(String name) throws SubjectNotExistsException, ServiceException, SecurityException {
        return AuthenticationRepositoryService.getSubject(Domain.getCurrentDomain(), name);
    }

    public static Subject getSubject(Subject subj) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Domain domain = Domain.getDomain(subj.getDomainName());
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetSubject(subj);
    }

    public static Subject getSubject(Domain domain, String name) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetSubject(name);
    }

    protected abstract Subject doGetSubject(String var1) throws SubjectNotExistsException, ServiceException, SecurityException;

    protected abstract Subject doGetSubject(Subject var1) throws SubjectNotExistsException, ServiceException, SecurityException;

    public static Set getSubjectNames() throws ServiceException, SecurityException {
        return AuthenticationRepositoryService.getSubjectNames(Domain.getCurrentDomain());
    }

    public static Set getSubjectNames(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetSubjectNames();
    }

    public static Subject[] getSubjects(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetSubjectsAsArray();
    }

    protected abstract Set doGetSubjectNames() throws ServiceException, SecurityException;

    protected abstract Subject[] doGetSubjectsAsArray() throws ServiceException, SecurityException;

    public static void addSubject(Subject subject) throws ServiceException, SecurityException {
        AuthenticationRepositoryService.addSubject(Domain.getCurrentDomain(), subject);
    }

    public static void addSubject(Domain domain, Subject subject) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doAddSubject(subject);
        Event ev = new Event("Added Subject data", SUBJECT_ADDED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("subject", subject);
        EventHandlingService.handleEvent(ev);
    }

    protected abstract void doAddSubject(Subject var1, boolean var2) throws ServiceException, SecurityException;

    protected abstract void doRemoveSubject(Subject var1, boolean var2) throws SubjectNotExistsException, ServiceException, SecurityException;

    protected abstract void doAddSubject(Subject var1) throws ServiceException, SecurityException;

    public static void removeSubject(Subject subject) throws SubjectNotExistsException, ServiceException, SecurityException {
        AuthenticationRepositoryService.removeSubject(Domain.getCurrentDomain(), subject);
    }

    public static void removeSubject(Domain domain, Subject subject) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doRemoveSubject(subject);
        Event ev = new Event("Removed Subject data", SUBJECT_REMOVED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("subject", subject);
        EventHandlingService.handleEvent(ev);
    }

    protected abstract void doRemoveSubject(Subject var1) throws SubjectNotExistsException, ServiceException, SecurityException;

    public static void removeSubject(String name) throws SubjectNotExistsException, ServiceException, SecurityException {
        AuthenticationRepositoryService.removeSubject(Domain.getCurrentDomain(), name);
    }

    public static void removeSubject(Domain domain, String name) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doRemoveSubject(name);
        Event ev = new Event("Completely removed Subject", SUBJECT_REMOVED_COMPLETE_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("name", name);
        EventHandlingService.handleEvent(ev);
    }

    protected abstract void doRemoveSubject(String var1) throws SubjectNotExistsException, ServiceException, SecurityException;

    public Class getType() {
        return AuthenticationRepositoryService.class;
    }

    protected abstract void refreshRepositryService() throws ServiceException;

    protected abstract void doSave() throws ServiceException, SecurityException;

    protected abstract boolean doUserExists(String var1) throws ServiceException, SecurityException;

    protected abstract boolean doGroupExist(String var1) throws ServiceException, SecurityException;

    protected abstract void doAddGroup(Group var1) throws ServiceException, SecurityException;

    protected abstract void doAddUserToGroup(String var1, Principal var2) throws GroupNotExistsException, ServiceException, SecurityException;

    protected abstract Group doGetGroup(String var1) throws GroupNotExistsException, ServiceException, SecurityException;

    protected abstract Set doGetGroupNames() throws ServiceException, SecurityException;

    protected abstract Group[] doGetGroupList() throws ServiceException, SecurityException;

    protected abstract void doRemoveGroup(String var1) throws GroupNotExistsException, ServiceException, SecurityException;

    protected abstract void doRemoveUserFromGroup(String var1, Principal var2) throws GroupNotExistsException, ServiceException, SecurityException;

    protected abstract boolean doIsMember(String var1, Principal var2) throws GroupNotExistsException, ServiceException, SecurityException;

    protected abstract Enumeration doGetMembersFromGroup(String var1) throws GroupNotExistsException, ServiceException, SecurityException;

    public static void addSubjects(String domainName, Subject[] subjects, boolean localAdd) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (subjects == null) {
            return;
        }
        Domain domain = Domain.getDomain(domainName);
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        for (int i = 0; i < subjects.length; ++i) {
            Subject subject = subjects[i];
            ars.doAddSubject(subject, localAdd);
            Event ev = new Event("Added Subject data", SUBJECT_ADDED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
            ev.put("subject", subject);
            EventHandlingService.handleEvent(ev);
        }
    }

    public static void removeSubjects(String domainName, Subject[] subjects, boolean localRemove) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (subjects == null) {
            return;
        }
        Domain domain = Domain.getDomain(domainName);
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        for (int i = 0; i < subjects.length; ++i) {
            Subject subject = subjects[i];
            ars.doRemoveSubject(subject, localRemove);
            Event ev = new Event("Removed Subject data", SUBJECT_REMOVED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
            ev.put("subject", subject);
            EventHandlingService.handleEvent(ev);
        }
    }

    public static void save() throws ServiceException, SecurityException {
        AuthenticationRepositoryService.save(Domain.getCurrentDomain());
    }

    public static void refresh() throws ServiceException, SecurityException {
        AuthenticationRepositoryService.refresh(Domain.getCurrentDomain());
    }

    public static void save(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doSave();
        Event ev = new Event("Save Subject", SUBJECT_SAVED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        EventHandlingService.handleEvent(ev);
    }

    public static void refresh(Domain domain) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.refreshRepositryService();
    }

    public static boolean userExist(String userName) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return false;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doUserExists(userName);
    }

    public static boolean groupExist(String groupName) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return false;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGroupExist(groupName);
    }

    public static void addGroup(Group group) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doAddGroup(group);
        Event ev = new Event("Added Group data", GROUP_ADDED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("group", group);
        EventHandlingService.handleEvent(ev);
    }

    public static void addUserToGroup(String groupName, Principal userName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doAddUserToGroup(groupName, userName);
        Event ev = new Event("Added User to group", GROUP_ADDED_USER_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("group", groupName + ":" + userName.getName());
        EventHandlingService.handleEvent(ev);
    }

    public static Group[] getGroupList() throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetGroupList();
    }

    public static Set getGroupNames() throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetGroupNames();
    }

    public static void removeGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doRemoveGroup(groupName);
        Event ev = new Event("Removed Group data", GROUP_REMOVED_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("group", groupName);
        EventHandlingService.handleEvent(ev);
    }

    public static void removeUserFromGroup(String groupName, Principal userName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.doRemoveUserFromGroup(groupName, userName);
        Event ev = new Event("Removed Group data", GROUP_ADDED_USER_EVENT_TYPE, Event.INFORMATION, null, AuthenticationRepositoryService.class.getName());
        ev.put("group", groupName + ":" + userName.getName());
        EventHandlingService.handleEvent(ev);
    }

    public static Group getGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doGetGroup(groupName);
    }

    public static boolean isMember(String groupName, Principal userName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return false;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.doIsMember(groupName, userName);
    }

    public static String getMembersFromGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return EnumerationUtil.toString(ars.doGetMembersFromGroup(groupName));
    }

    public static ArrayList getMemberListFromGroup(String groupName) throws GroupNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        Enumeration enums = ars.doGetMembersFromGroup(groupName);
        ArrayList list = new ArrayList();
        while (enums.hasMoreElements()) {
            list.add(enums.nextElement());
        }
        return list;
    }

    public static Object readSubject(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        return ars.readSubjectsInRepository();
    }

    public static void writeSubject(Domain domain, Object subjects) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthenticationRepositoryService.class);
        AuthenticationRepositoryService ars = (AuthenticationRepositoryService)s;
        ars.writeSubjectsToRepository(subjects);
    }

    protected abstract Object readSubjectsInRepository() throws ServiceException;

    protected abstract void writeSubjectsToRepository(Object var1) throws ServiceException;
}

