/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectNotExistsException;

public abstract class AuthorizationRepositoryService
extends Service {
    public static final String POLICY_ADDED_EVENT_TYPE = "security.authorization.repository.policy.added";
    public static final String POLICY_REMOVED_EVENT_TYPE = "security.authorization.repository.policy.removed";
    public static final String POLICY_REMOVED_COMPLETE_EVENT_TYPE = "security.authorization.repository.policy.removed.complete";
    public static final String POLICY_SAVED_EVENT_TYPE = "security.authorization.repository.policy.saved";
    public static final ResourcePermission ADD_POLICY_PERMISSION = new ResourcePermission(AuthorizationRepositoryService.class.getName(), "addPolicy");
    public static final ResourcePermission REMOVE_POLICY_PERMISSION = new ResourcePermission(AuthorizationRepositoryService.class.getName(), "removePolicy");
    public static final ResourcePermission GET_POLICY_PERMISSION = new ResourcePermission(AuthorizationRepositoryService.class.getName(), "getPolicy");

    public static Policy getPolicy(String contextId) throws PolicyNotExistsException, ServiceException, SecurityException {
        return AuthorizationRepositoryService.getPolicy(Domain.getCurrentDomain(), contextId);
    }

    public static Policy getPolicy(Domain domain, String contextId) throws PolicyNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        return ars.doGetPolicy(contextId);
    }

    protected abstract Policy doGetPolicy(String var1) throws PolicyNotExistsException, ServiceException, SecurityException;

    public static Set getPolicyIds() throws ServiceException, SecurityException {
        return AuthorizationRepositoryService.getPolicyIds(Domain.getCurrentDomain());
    }

    public static Set getPolicyIds(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        return ars.doGetPolicyIds();
    }

    public static Policy[] getPolicys(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        return ars.doGetPoliciesAsArray();
    }

    protected abstract Set doGetPolicyIds() throws ServiceException, SecurityException;

    protected abstract Policy[] doGetPoliciesAsArray() throws ServiceException, SecurityException;

    public static void addPolicy(Policy policy) throws ServiceException, SecurityException {
        AuthorizationRepositoryService.addPolicy(Domain.getCurrentDomain(), policy, false);
    }

    public static void addPolicy(Domain domain, Policy policy) throws ServiceException, SecurityException {
        AuthorizationRepositoryService.addPolicy(domain, policy, false);
    }

    public static void addPolicy(Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        AuthorizationRepositoryService.addPolicy(Domain.getCurrentDomain(), policy, localAdd);
    }

    public static void addPolicy(Domain domain, Policy policy, boolean localAdd) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.doAddPolicy(policy, localAdd);
        Event ev = new Event("Added Policy data", POLICY_ADDED_EVENT_TYPE, Event.INFORMATION, null, AuthorizationRepositoryService.class.getName());
        ev.put("policy", policy);
        EventHandlingService.handleEvent(ev);
    }

    protected abstract void doAddPolicy(Policy var1, boolean var2) throws ServiceException, SecurityException;

    public static void removePolicy(Policy policy, boolean localRemove) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(Domain.getCurrentDomain(), policy, localRemove);
    }

    public static void removePolicy(Domain domain, Policy policy, boolean localRemove) throws PolicyNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.doRemovePolicy(policy, localRemove);
        Event ev = new Event("Removed Policy data", POLICY_REMOVED_EVENT_TYPE, Event.INFORMATION, null, AuthorizationRepositoryService.class.getName());
        ev.put("policy", policy);
        EventHandlingService.handleEvent(ev);
    }

    public static void removePolicy(Policy policy) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(Domain.getCurrentDomain(), policy, false);
    }

    public static void removePolicy(Domain domain, Policy policy) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(domain, policy, false);
    }

    protected abstract void doRemovePolicy(Policy var1, boolean var2) throws PolicyNotExistsException, ServiceException, SecurityException;

    public static void removePolicy(String contextId, boolean localRemove) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(Domain.getCurrentDomain(), contextId, localRemove);
    }

    public static void removePolicy(Domain domain, String contextId, boolean localRemove) throws PolicyNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.doRemovePolicy(contextId, localRemove);
        Event ev = new Event("Completely removed Policy context", POLICY_REMOVED_COMPLETE_EVENT_TYPE, Event.INFORMATION, null, AuthorizationRepositoryService.class.getName());
        ev.put("contextid", contextId);
        EventHandlingService.handleEvent(ev);
    }

    public static void removePolicy(String contextId) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(Domain.getCurrentDomain(), contextId, false);
    }

    public static void removePolicy(Domain domain, String contextId) throws PolicyNotExistsException, ServiceException, SecurityException {
        AuthorizationRepositoryService.removePolicy(domain, contextId, false);
    }

    protected abstract void doRemovePolicy(String var1, boolean var2) throws PolicyNotExistsException, ServiceException, SecurityException;

    public final Class getType() {
        return AuthorizationRepositoryService.class;
    }

    public static void save() throws ServiceException, SecurityException {
        AuthorizationRepositoryService.save(Domain.getCurrentDomain());
    }

    public static void refresh() throws ServiceException, SecurityException {
        AuthorizationRepositoryService.refresh(Domain.getCurrentDomain());
    }

    public static void save(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.doSave();
        Event ev = new Event("Save Policy", POLICY_SAVED_EVENT_TYPE, Event.INFORMATION, null, AuthorizationRepositoryService.class.getName());
        EventHandlingService.handleEvent(ev);
    }

    protected abstract void doSave() throws ServiceException, SecurityException;

    public static void refresh(Domain domain) throws SubjectNotExistsException, ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.refreshRepositryService();
    }

    public static Object readPolicy(Domain domain) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        return ars.readPoliciesInRepository();
    }

    public static void writePolicy(Domain domain, Object policies) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        Service s = domain.getOneService(AuthorizationRepositoryService.class);
        AuthorizationRepositoryService ars = (AuthorizationRepositoryService)s;
        ars.writePoliciesToRepository(policies);
    }

    protected abstract void refreshRepositryService() throws ServiceException;

    protected abstract Object readPoliciesInRepository() throws ServiceException;

    protected abstract void writePoliciesToRepository(Object var1) throws ServiceException;
}

