/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.SecurityInstaller;

public abstract class CredentialVerificationService
extends Service {
    public static final String CREDENTIAL_VALIDATION_FAILED_EVENT_TYPE = "credential.validation.failed";

    public static void verifyCredentials(Subject referenceSubject, Subject proofSubject) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        for (CredentialVerificationService svs : Domain.getCurrentDomain().getZeroOrMoreServices(CredentialVerificationService.class)) {
            if (!svs.handles(referenceSubject, proofSubject)) continue;
            try {
                svs.doVerifyCredentials(referenceSubject, proofSubject);
            }
            catch (SecurityException se) {
                Event ev = new Event(se.getMessage(), CREDENTIAL_VALIDATION_FAILED_EVENT_TYPE, Event.WARNING, se, CredentialVerificationService.class.getName());
                ev.put("subject", proofSubject);
                EventHandlingService.handleEvent(ev);
                continue;
            }
            return;
        }
        throw new SecurityException("Failed to verify credentials");
    }

    protected abstract void doVerifyCredentials(Subject var1, Subject var2) throws ServiceException, SecurityException;

    protected abstract boolean handles(Subject var1, Subject var2);

    public final Class getType() {
        return CredentialVerificationService.class;
    }
}

