/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.util.Iterator;
import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.SecurityInstaller;

public abstract class IdentityAssertionService
extends Service {
    public static final String IDENTITY_FAILED_EVENT_TYPE = "security.getidentity.failed";

    public static Object getIdentity(Object cred) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Iterator ass = Domain.getCurrentDomain().getOneOrMoreServices(IdentityAssertionService.class).iterator();
        Throwable lastSE = null;
        while (ass.hasNext()) {
            IdentityAssertionService as = (IdentityAssertionService)ass.next();
            try {
                return as.doIdentity(cred);
            }
            catch (SecurityException se) {
                se.printStackTrace();
                lastSE = se;
            }
        }
        if (lastSE != null) {
            Event ev = new Event(lastSE.getMessage(), IDENTITY_FAILED_EVENT_TYPE, Event.WARNING, lastSE, AuthenticationService.class.getName());
            ev.put("identity", cred);
            EventHandlingService.handleEvent(ev);
            throw lastSE;
        }
        throw new ServiceException("Authentication failed: no AuthenticationService instances configured");
    }

    protected abstract Object doIdentity(Object var1) throws ServiceException, SecurityException;

    public final Class getType() {
        return IdentityAssertionService.class;
    }
}

