/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.io.Serializable;
import java.security.Permission;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.Policy;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectValidationService;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.LoginUtil;
import jeus.security.util.NetworkUtil;

public abstract class NetworkService
extends Service {
    private static ThreadLocal currentNetworkMessage = new ThreadLocal();

    public static NetworkMessage getCurrentNetworkMessage() {
        Object o = currentNetworkMessage.get();
        if (o != null) {
            return (NetworkMessage)o;
        }
        return null;
    }

    public static int getCurrentBroadcastType() {
        NetworkMessage msg = NetworkService.getCurrentNetworkMessage();
        if (msg != null) {
            if (msg.getBroadcastType() == 0) {
                return 1;
            }
            if (msg.getBroadcastType() == 1) {
                return 2;
            }
        }
        return 0;
    }

    public static Environment[] getRemoteEnvironments() throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(NetworkService.class);
        NetworkService ns = (NetworkService)s;
        return ns.doGetRemoteEnvironments();
    }

    protected abstract Environment[] doGetRemoteEnvironments();

    public static Object sendMessage(NetworkMessage message, boolean broadcast) throws ServiceException, SecurityException {
        return NetworkService.sendMessage(message, broadcast, null);
    }

    public static Object sendMessage(NetworkMessage message, boolean broadcast, Environment targetEnv) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(NetworkService.class);
        NetworkService ns = (NetworkService)s;
        return ns.doSendMessage(message, broadcast, targetEnv);
    }

    public static Object sendMessage(NetworkMessage message, String targetNode) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        Service s = Domain.getCurrentDomain().getOneService(NetworkService.class);
        NetworkService ns = (NetworkService)s;
        return ns.doSendMessage(message, targetNode);
    }

    protected abstract Object doSendMessage(NetworkMessage var1, boolean var2, Environment var3) throws ServiceException, SecurityException;

    protected abstract Object doSendMessage(NetworkMessage var1, String var2) throws ServiceException, SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processMessage(NetworkMessage message) {
        currentNetworkMessage.set(message);
        byte opcode = message.getOpcode();
        Object[] objects = message.getArguments();
        boolean loggedIn = false;
        try {
            Object result;
            loggedIn = this.loginSubject(message, loggedIn);
            Object object = result = this.doProcessMessage(opcode, objects);
            return object;
        }
        catch (Throwable e) {
            Throwable throwable = e;
            return throwable;
        }
        finally {
            block12: {
                currentNetworkMessage.set(null);
                if (loggedIn) {
                    try {
                        LoginService.logout();
                    }
                    catch (Exception e) {
                        if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._31_LEVEL)) break block12;
                        LoggerUtil.logger.log(JeusMessage_Security._31_LEVEL, JeusMessage_Security._31, (Throwable)e);
                    }
                }
            }
        }
    }

    protected abstract boolean loginSubject(NetworkMessage var1, boolean var2) throws ServiceException, SecurityException;

    private Object doProcessMessage(byte opcode, Object[] args) throws Throwable {
        switch (opcode) {
            case 1: {
                Subject subject = AuthenticationService.authenticate((Subject)args[0]);
                NetworkMessage message = new NetworkMessage(64, subject, null);
                return message;
            }
            case 2: {
                Subject subject = AuthenticationRepositoryService.getSubject((String)args[0]);
                NetworkMessage message = new NetworkMessage(64, subject, null);
                return message;
            }
            case 3: {
                Serializable data = (Serializable)((Object)AuthenticationRepositoryService.getSubjectNames());
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 4: {
                AuthenticationRepositoryService.addSubject((Subject)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 5: {
                AuthenticationRepositoryService.removeSubject((Subject)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 6: {
                AuthenticationRepositoryService.removeSubject((String)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 16: {
                AuthenticationRepositoryService.save();
                return NetworkMessage.NULL_REPLY;
            }
            case 7: {
                AuthorizationService.authorize((String)args[0], (Permission)args[1], (Subject)args[2]);
                return NetworkMessage.NULL_REPLY;
            }
            case 8: {
                Policy data = AuthorizationRepositoryService.getPolicy((String)args[0]);
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 9: {
                Serializable data = (Serializable)((Object)AuthorizationRepositoryService.getPolicyIds());
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 10: {
                AuthorizationRepositoryService.addPolicy((Policy)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 11: {
                AuthorizationRepositoryService.removePolicy((Policy)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 12: {
                AuthorizationRepositoryService.removePolicy((String)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 17: {
                AuthorizationRepositoryService.save();
                return NetworkMessage.NULL_REPLY;
            }
            case 13: {
                LoginUtil.loginTest();
                return NetworkMessage.NULL_REPLY;
            }
            case 14: {
                LoginService.checkPermission((String)args[0], (Permission)args[1]);
                return NetworkMessage.NULL_REPLY;
            }
            case 15: {
                SubjectValidationService.checkValidity((Subject)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 18: {
                GroupPrincipalImpl group = (GroupPrincipalImpl)AuthenticationRepositoryService.getGroup((String)args[0]);
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{group});
                return message;
            }
            case 20: {
                Serializable data = (Serializable)((Object)AuthenticationRepositoryService.getGroupNames());
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 19: {
                GroupPrincipalImpl[] data = (GroupPrincipalImpl[])AuthenticationRepositoryService.getGroupList();
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 25: {
                String data = AuthenticationRepositoryService.getMembersFromGroup((String)args[0]);
                NetworkMessage message = new NetworkMessage(65, null, new Serializable[]{data});
                return message;
            }
            case 21: {
                AuthenticationRepositoryService.addGroup((GroupPrincipalImpl)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 22: {
                AuthenticationRepositoryService.addUserToGroup((String)args[0], (PrincipalImpl)args[1]);
                return NetworkMessage.NULL_REPLY;
            }
            case 23: {
                AuthenticationRepositoryService.removeGroup((String)args[0]);
                return NetworkMessage.NULL_REPLY;
            }
            case 24: {
                AuthenticationRepositoryService.removeUserFromGroup((String)args[0], (PrincipalImpl)args[1]);
                return NetworkMessage.NULL_REPLY;
            }
        }
        throw new ServiceException("Failed invoking method: the static method named " + NetworkUtil.getMethodName(opcode) + " in class " + NetworkUtil.getClassName(opcode) + " does not exist : " + opcode);
    }

    public final Class getType() {
        return NetworkService.class;
    }
}

