/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.SecurityInstaller;

public abstract class SubjectValidationService
extends Service {
    public static final String SUBJECT_VALIDATION_FAILED_EVENT_TYPE = "subject.validation.failed";

    public static void checkValidity(Subject subject) throws SecurityException, ServiceException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        for (SubjectValidationService svs : Domain.getCurrentDomain().getZeroOrMoreServices(SubjectValidationService.class)) {
            try {
                svs.doCheckValidity(subject);
            }
            catch (SecurityException se) {
                Event ev = new Event(se.getMessage(), SUBJECT_VALIDATION_FAILED_EVENT_TYPE, Event.WARNING, se, SubjectValidationService.class.getName());
                ev.put("subject", subject);
                EventHandlingService.handleEvent(ev);
                throw se;
            }
        }
    }

    protected abstract void doCheckValidity(Subject var1) throws SecurityException, ServiceException;

    public final Class getType() {
        return SubjectValidationService.class;
    }
}

