/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;
import jeus.security.util.SQLBuilder;

public abstract class DBRealmConverter {
    protected Connection conn;
    protected Statement stmt;
    protected PreparedStatement pstmt;
    protected String domainName;
    protected String dsExportName;
    protected String vendor = "oracle";
    protected Properties prop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
        }
        finally {
            this.stmt = null;
            this.conn = null;
            this.pstmt = null;
        }
    }

    protected abstract void connect() throws Exception;

    public void executeUpdate(String[] sqls) {
        try {
            this.connect();
            for (int i = 0; i < sqls.length; ++i) {
                this.stmt.executeUpdate(sqls[i]);
            }
            this.conn.commit();
            this.close();
        }
        catch (SQLException e) {
            block8: {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
                }
                try {
                    this.conn.rollback();
                }
                catch (Exception ex) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) break block8;
                    LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
                }
            }
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
    }

    public ResultSet executeQuery(String sql) {
        ResultSet result = null;
        try {
            this.connect();
            result = this.stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            this.close();
        }
        return result;
    }

    public ResultSet executeQuery(String sql, String[] keys) {
        ResultSet result = null;
        try {
            this.connect();
            this.pstmt = this.conn.prepareStatement(sql);
            for (int i = 1; i <= keys.length; ++i) {
                this.pstmt.setString(i, keys[i - 1]);
            }
            result = this.pstmt.executeQuery();
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
        return result;
    }

    public void executeUpdateQuery(String sql, String[] keys) {
        try {
            this.connect();
            this.pstmt = this.conn.prepareStatement(sql);
            for (int i = 1; i <= keys.length; ++i) {
                this.pstmt.setString(i, keys[i - 1]);
            }
            this.pstmt.executeUpdate();
            this.conn.commit();
        }
        catch (SQLException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._36_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._36_LEVEL, JeusMessage_Security._36, (Throwable)e);
            }
            e.printStackTrace();
            this.close();
        }
    }

    protected String getCreateQuery(String table, String[] columns, String[] columnsType, String[] primaryKeyColumns) {
        int i;
        SQLBuilder builder = new SQLBuilder();
        builder.initCreateTableSQL();
        builder.setTableName(table);
        builder.beginColumnDeclaration();
        for (i = 0; i < columns.length; ++i) {
            builder.addColumnDeclaration(columns[i], columnsType[i]);
            for (int j = 0; j < primaryKeyColumns.length; ++j) {
                if (!columns[i].equals(primaryKeyColumns[j])) continue;
                builder.addNotNullConstraint();
            }
        }
        builder.beginPrimaryKeyConstraint();
        for (i = 0; i < primaryKeyColumns.length; ++i) {
            builder.addColumnName(primaryKeyColumns[i]);
        }
        builder.finishPrimaryKeyConstraint();
        builder.finishColumnDeclaration();
        return builder.getSQL();
    }

    protected String getInsertQuery(String table, String[] columns, String[] values) {
        SQLBuilder builder = new SQLBuilder();
        builder.initInsertSQL();
        builder.setTableName(table);
        builder.beginColumnName();
        builder.addColumnName(columns);
        builder.finishColumnName();
        builder.beginValues();
        builder.addValueList(columns.length, values);
        builder.finishValues();
        return builder.getSQL();
    }

    protected String getSelectQuery(String table, String[] columns, String[] whereColumns, String[] values) {
        SQLBuilder builder = new SQLBuilder();
        builder.initSelectSQL();
        builder.addColumnName(columns);
        builder.beginFromClause();
        builder.setTableName(table);
        builder.finishFromClause();
        builder.beginWhereClause();
        builder.addWhereQuestion(whereColumns, values);
        builder.finishWhereClause();
        return builder.getSQL();
    }

    protected String getDropQuery(String table) {
        SQLBuilder builder = new SQLBuilder();
        builder.initDeleteTableSQL();
        builder.setTableName(table);
        builder.addString("cascade constraints");
        return builder.getSQL();
    }

    protected String getUpDateQuery(String table, String[] columns, String[] columnValues, String[] whereColumns, String[] whereColumnValues) {
        SQLBuilder builder = new SQLBuilder();
        builder.initUpdateSQL();
        builder.setTableName(table);
        builder.beginSetClause();
        for (int i = 1; i < columns.length; ++i) {
            builder.addSetColumn(columns[i], columnValues[i]);
        }
        builder.finishSetClause();
        builder.beginWhereClause();
        builder.addWhereQuestion(whereColumns, whereColumnValues);
        builder.finishWhereClause();
        return builder.getSQL();
    }

    protected String getDeleteQuery(String table) {
        SQLBuilder builder = new SQLBuilder();
        builder.initDeleteSQL();
        builder.setTableName(table);
        return builder.getSQL();
    }

    protected String getDeleteQuery(String table, String[] whereColumns, String[] whereColumnValues) {
        SQLBuilder builder = new SQLBuilder();
        builder.initDeleteSQL();
        builder.setTableName(table);
        builder.beginWhereClause();
        builder.addWhereQuestion(whereColumns, whereColumnValues);
        builder.finishWhereClause();
        return builder.getSQL();
    }
}

