/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import jeus.security.util.Base64Coder;
import jeus.security.util.Constants;
import jeus.security.util.EncryptionInfo;
import jeus.security.util.JeusSecurityRandom;
import jeus.security.util.LoggerUtil;
import jeus.util.CUtility;
import jeus.util.EnvironmentCall;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusPropertyValues;

public class EncryptionUtil {
    private static Cipher cipher;
    private static String secretKeyPath;
    private static String secretKeyDir;
    private static String secretKeyFileName;
    private static Map cipherTable;
    private static Map encryptionInfoTable;
    private static Map secretKeyFileObjectTable;
    private static Map messageDigestTable;
    private static JeusSecurityRandom jeusRandom;
    private static final int DEFAULT_SALT_KEY_LENGTH = 8;
    private static final byte[] SALT_FOR_SECRET_KEY;
    private static final int ITERATION_COUNT = 1000;
    private static boolean isCreated;
    private static String passwordForSecretKey;
    public static final int ENCODED_PASS_MAGIC_NUMBER = 537395984;
    public static final int ENCODED_PASS_MAX_LENGTH = 512;

    public static void init(String dir) {
        if (!isCreated) {
            secretKeyDir = dir;
            secretKeyPath = dir + File.separator + secretKeyFileName;
            EncryptionUtil.initSalt();
            EncryptionUtil.loadSecretKeyFile();
            isCreated = true;
        }
    }

    public static void init(String dir, Provider provider) {
        if (!isCreated) {
            secretKeyDir = dir;
            secretKeyPath = dir + File.separator + secretKeyFileName;
            Security.addProvider(provider);
            EncryptionUtil.initSalt();
            EncryptionUtil.loadSecretKeyFile();
            isCreated = true;
        }
    }

    public static boolean isCreated() {
        return isCreated;
    }

    public static void setSecretKeyDir(String dir) {
        secretKeyDir = dir;
        secretKeyPath = dir + File.separator + secretKeyFileName;
    }

    public static void initSalt() {
        if (jeusRandom == null) {
            jeusRandom = new JeusSecurityRandom();
            byte[] seedBytes = EncryptionUtil.getRandomBytes(null, 8);
            jeusRandom.setSeed(seedBytes);
            seedBytes[0] = 0;
        }
    }

    public static byte[] getSalt() {
        if (jeusRandom != null) {
            return jeusRandom.nextBytes(new byte[8]);
        }
        throw new SecurityException("jeusRandom Number Generator is not initialized");
    }

    private static byte[] getRandomBytes(String algorithm, int keyLength) {
        SecureRandom secureRandom;
        if (algorithm == null) {
            secureRandom = new SecureRandom();
        } else {
            try {
                secureRandom = SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                secureRandom = new SecureRandom();
            }
        }
        try {
            secureRandom.setSeed(System.getProperty("java.version", "default").getBytes());
            secureRandom.setSeed(System.getProperty("java.vendor", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.name", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.version", "default").getBytes());
            secureRandom.setSeed(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] abyte0 = new byte[keyLength];
        secureRandom.nextBytes(abyte0);
        return abyte0;
    }

    public static boolean isProtected() {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (encryptionInfo.getSecretKey() != null) continue;
            return true;
        }
        return false;
    }

    public static String getPasswordForSecretKey() {
        return passwordForSecretKey;
    }

    public static void initPasswordForSecretKey() {
        for (int i = 0; i <= 2; ++i) {
            System.out.print("Input Your Password For Key Encryption> ");
            String pass = new String(CUtility.getInputBytes());
            System.out.println("");
            System.out.print("Repeat Your Password For Key Encryption> ");
            String confirm = new String(CUtility.getInputBytes());
            System.out.println("");
            if (pass.equals(confirm) && pass != null && !pass.equals("")) {
                String passwd = new String(pass);
                passwordForSecretKey = EncryptionUtil.encryptPassword("base64", passwd);
                break;
            }
            System.out.println("Retry!");
            if (i != 2) continue;
            throw new SecurityException();
        }
        EncryptionUtil.cacheEncryptionInfo();
        if (!encryptionInfoTable.isEmpty()) {
            EncryptionUtil.writeSecretKey(null);
        }
    }

    public static void inputPasswordForSecretKey() {
        for (int i = 0; i <= 2; ++i) {
            try {
                System.out.println("secret key file is encrypted. Enter the master password.");
                System.out.print("password> ");
                String password = new String(CUtility.getInputBytes());
                System.out.println("");
                System.out.println("");
                EncryptionUtil.masterPasswordValidation(password);
                passwordForSecretKey = EncryptionUtil.encryptPassword("base64", password);
                return;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (LoggerUtil.logger.isLoggable(JeusMessage_Manager1._560_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Manager1._560_LEVEL, "[ERROR] entered master password is incorrect.");
        }
        throw new SecurityException("Your password is incorrect, try again.");
    }

    public static void setPasswordForSecretKey(String password) {
        passwordForSecretKey = password;
    }

    private static EncryptionInfo convertFromEncryptedToPlainInfo(EncryptionInfo encryptionInfo, String password) {
        if (passwordForSecretKey == null) {
            throw new SecurityException("Security Exception : key-encryption password is not initialized.");
        }
        SecretKey secretKey = null;
        try {
            secretKey = EncryptionUtil.keyDecryptionWithTripleDES(password.toCharArray(), encryptionInfo);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        encryptionInfo = new EncryptionInfo(encryptionInfo.getCipherAlgorithm(), secretKey, encryptionInfo.getIps(), encryptionInfo.getSalt());
        return encryptionInfo;
    }

    private static EncryptionInfo convertFromPlainToEncryptedInfo(EncryptionInfo encryptionInfo, String password) {
        if (passwordForSecretKey == null) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                LoggerUtil.logger.log(Level.FINEST, "key-encryption password is not initialized.");
            }
            throw new SecurityException("Security Exception : key-encryption password is not initialized.");
        }
        byte[] encryptedSecretKey = null;
        try {
            encryptedSecretKey = EncryptionUtil.keyEncryptionWithTripleDES(password.toCharArray(), encryptionInfo.getSecretKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityException("Your Key-Encrypt Password is incorrect, try again.");
        }
        return new EncryptionInfo(encryptionInfo.getCipherAlgorithm(), encryptedSecretKey, encryptionInfo.getIps(), encryptionInfo.getSalt());
    }

    private static byte[] keyEncryptionWithTripleDES(char[] passwdForKey, SecretKey key) throws NoSuchAlgorithmException, NoSuchPaddingException {
        cipher = Cipher.getInstance("PBEWithSHAAnd2-KeyTripleDES-CBC");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passwdForKey, SALT_FOR_SECRET_KEY, 1000);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithSHAAnd2-KeyTripleDES-CBC");
        byte[] encodedKey = null;
        byte[] keyBytes = key.getEncoded();
        try {
            SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
            cipher.init(1, secretKey);
            encodedKey = cipher.doFinal(keyBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedKey;
    }

    private static SecretKey keyDecryptionWithTripleDES(char[] passwdForKey, EncryptionInfo encryptionInfo) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        cipher = Cipher.getInstance("PBEWithSHAAnd2-KeyTripleDES-CBC");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passwdForKey, SALT_FOR_SECRET_KEY, 1000);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithSHAAnd2-KeyTripleDES-CBC");
        byte[] encryptedKey = encryptionInfo.getEncryptedSecretKey();
        byte[] keyBytes = null;
        SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
        cipher.init(2, secretKey);
        keyBytes = cipher.doFinal(encryptedKey);
        SecretKeySpec plainKey = new SecretKeySpec(keyBytes, encryptionInfo.getCipherAlgorithm());
        return plainKey;
    }

    public static String encode(String algorithm, String plainPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            cipherTable.put(algorithm, cipher);
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm);
        String encodePassword = null;
        if (encryptionInfo == null) {
            try {
                encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            }
            catch (IOException e) {
                encryptionInfo = null;
            }
            catch (ClassNotFoundException e) {
                throw new SecurityException(e);
            }
            if (encryptionInfo == null) {
                KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
                SecretKey secretKey = keygen.generateKey();
                byte[] salt = EncryptionUtil.getSalt();
                encodePassword = EncryptionUtil.encode(secretKey, plainPassword, salt);
                byte[] iv = cipher.getIV();
                IvParameterSpec ips = new IvParameterSpec(iv);
                encryptionInfo = new EncryptionInfo(algorithm, secretKey, ips.getIV(), salt);
                EncryptionUtil.writeSecretKey(encryptionInfo);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                if (encryptionInfo.getSecretKey() != null) {
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                } else {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                }
                encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, encryptionInfo.getSalt());
            }
        } else {
            encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, encryptionInfo.getSalt());
        }
        return encodePassword;
    }

    public static String encodeForConverter(String algorithm, String plainPassword, String dir) throws NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        secretKeyDir = dir;
        secretKeyPath = dir + File.separator + secretKeyFileName;
        cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            cipherTable.put(algorithm, cipher);
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm);
        String encodePassword = null;
        if (encryptionInfo == null) {
            try {
                encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            }
            catch (IOException e) {
                encryptionInfo = null;
            }
            catch (ClassNotFoundException e) {
                throw new SecurityException(e);
            }
            if (encryptionInfo == null) {
                KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
                SecretKey secretKey = keygen.generateKey();
                byte[] salt = EncryptionUtil.getSalt();
                encodePassword = EncryptionUtil.encode(secretKey, plainPassword, salt);
                byte[] iv = cipher.getIV();
                IvParameterSpec ips = new IvParameterSpec(iv);
                encryptionInfo = new EncryptionInfo(algorithm, secretKey, ips.getIV(), salt);
                EncryptionUtil.writeSecretKey(encryptionInfo);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                if (encryptionInfo.getSecretKey() != null) {
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                } else {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                }
                encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, encryptionInfo.getSalt());
            }
        } else {
            if (!new File(secretKeyPath).exists()) {
                EncryptionUtil.writeSecretKey(encryptionInfo);
            }
            encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, encryptionInfo.getSalt());
        }
        return encodePassword;
    }

    public static String decode(String algorithm, String encodedPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, ClassNotFoundException, IOException {
        String password;
        EncryptionInfo encryptionInfo;
        cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            cipherTable.put(algorithm, cipher);
        }
        if ((encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm)) == null) {
            encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            if (encryptionInfo == null) {
                return encodedPassword;
            }
            if (encryptionInfo.getSecretKey() != null) {
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            }
        }
        if (encryptionInfo.getSecretKey() != null) {
            return EncryptionUtil.decode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), encodedPassword, encryptionInfo.getSalt());
        }
        password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
        encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
        return EncryptionUtil.decode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), encodedPassword, encryptionInfo.getSalt());
    }

    public static String createPasswordHash(String algorithm, String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest msgDigest = (MessageDigest)messageDigestTable.get(algorithm);
        if (msgDigest == null) {
            msgDigest = MessageDigest.getInstance(algorithm);
        }
        byte[] passBytes = password.getBytes("UTF-8");
        byte[] hash = msgDigest.digest(passBytes);
        return Base64Coder.byteArrayToBase64(hash);
    }

    public static String encryptPassword(String algorithm, String password) {
        try {
            if (algorithm == null) {
                return password;
            }
            if (algorithm.equalsIgnoreCase("base64")) {
                return Base64Coder.encode(password);
            }
            if (algorithm.equalsIgnoreCase("SHA")) {
                return EncryptionUtil.createPasswordHash(algorithm, password);
            }
            return EncryptionUtil.encode(algorithm, password);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.logger.log("You have entered invalid algorithm value : " + algorithm);
            LoggerUtil.logger.log("valid algorithm value : base64|SHA|DES|DESede|AES|SEED|Blowfish ");
            return null;
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptPasswordForConverter(String algorithm, String password, String dir) {
        try {
            if (algorithm == null) {
                return password;
            }
            if (algorithm.equalsIgnoreCase("base64")) {
                return Base64Coder.encode(password);
            }
            if (algorithm.equalsIgnoreCase("SHA")) {
                return EncryptionUtil.createPasswordHash(algorithm, password);
            }
            return EncryptionUtil.encodeForConverter(algorithm, password, dir);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.logger.log("You have entered invalid algorithm value : " + algorithm);
            LoggerUtil.logger.log("valid algorithm value : base64|SHA|DES|DESede|AES|SEED|Blowfish ");
            return null;
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptPassword(String password) {
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        return EncryptionUtil.encryptPassword(algorithm, onlyPassword);
    }

    public static String[] getPasswordInfo(String password) {
        String[] info = new String[]{null, null};
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        info[0] = algorithm;
        info[1] = EncryptionUtil.encryptPassword(algorithm, onlyPassword);
        return info;
    }

    public static boolean checkAlgorithm(String algorithm) {
        if (algorithm == null) {
            return false;
        }
        for (int i = 0; i < Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES.length; ++i) {
            if (!Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[i].equalsIgnoreCase(algorithm)) continue;
            return true;
        }
        return false;
    }

    public static String decryptPassword(String algorithm, String password) {
        try {
            if (algorithm == null) {
                return password;
            }
            if (algorithm.equalsIgnoreCase("base64")) {
                return Base64Coder.decode(password);
            }
            if (algorithm.equalsIgnoreCase("SHA")) {
                return EncryptionUtil.createPasswordHash(algorithm, password);
            }
            return EncryptionUtil.decode(algorithm, password);
        }
        catch (UnsupportedEncodingException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            LoggerUtil.logger.log("You have entered invalid algorithm value : " + algorithm);
            LoggerUtil.logger.log("valid algorithm value : base64|SHA|DES|DESede|AES|SEED|Blowfish ");
            return null;
        }
        catch (NoSuchPaddingException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            return null;
        }
        catch (EOFException e) {
            return null;
        }
        catch (ClassCastException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            LoggerUtil.logger.log("Retry encryption execution :  Invalid security.key file (" + e.getMessage() + ")");
            return null;
        }
        catch (ClassNotFoundException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            LoggerUtil.logger.log("Retry encryption execution :  Invalid security.key file (" + e.getMessage() + ")");
            return null;
        }
        catch (IOException e) {
            if (LoggerUtil.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            LoggerUtil.logger.log("Retry encryption execution :  Invalid security.key file (" + e.getMessage() + ")");
            return null;
        }
    }

    public static String decryptPasswordForClientContainer(String password) {
        if (!isCreated) {
            EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusPropertyValues.fs + "security");
        }
        if (password == null) {
            return password;
        }
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        return EncryptionUtil.decryptPassword(algorithm, onlyPassword);
    }

    public static String decryptPassword(String password) {
        if (password == null) {
            return password;
        }
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                // empty catch block
            }
        }
        return EncryptionUtil.decryptPassword(algorithm, onlyPassword);
    }

    private static String decode(SecretKey secretKey, IvParameterSpec dps, String encodedPassword, byte[] salt) throws JeusException {
        byte[] decodedText;
        try {
            cipher.init(2, (Key)secretKey, dps);
            byte[] encodePassword = Base64Coder.base64ToByteArray(encodedPassword);
            byte[] onlyPassword = new byte[encodePassword.length - salt.length];
            System.arraycopy(encodePassword, 0, onlyPassword, 0, onlyPassword.length);
            decodedText = cipher.doFinal(onlyPassword);
        }
        catch (NullPointerException e) {
            throw new JeusException("[ERROR] Fail to decode the password. Because the Cipher can not be found. : " + encodedPassword);
        }
        catch (BadPaddingException e) {
            throw new JeusException("[ERROR] Fail to decode the password. Because the SecurityKey can not decode this password. : " + encodedPassword);
        }
        catch (Exception e) {
            throw new JeusException(e.getMessage());
        }
        return new String(decodedText);
    }

    private static String encode(SecretKey secretKey, String password, byte[] salt) {
        byte[] totalPassword = new byte[]{};
        try {
            cipher.init(1, secretKey);
            byte[] ciphertext = cipher.doFinal(password.getBytes("UTF-8"));
            totalPassword = new byte[ciphertext.length + salt.length];
            System.arraycopy(ciphertext, 0, totalPassword, 0, ciphertext.length);
            System.arraycopy(salt, 0, totalPassword, ciphertext.length, salt.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Base64Coder.byteArrayToBase64(totalPassword);
    }

    private static String encode(SecretKey secretKey, IvParameterSpec dps, String password, byte[] salt) {
        byte[] totalPassword = new byte[]{};
        try {
            cipher.init(1, (Key)secretKey, dps);
            byte[] ciphertext = cipher.doFinal(password.getBytes("UTF-8"));
            totalPassword = new byte[ciphertext.length + salt.length];
            System.arraycopy(ciphertext, 0, totalPassword, 0, ciphertext.length);
            System.arraycopy(salt, 0, totalPassword, ciphertext.length, salt.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Base64Coder.byteArrayToBase64(totalPassword);
    }

    public static void cacheEncryptionInfo() {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (encryptionInfo.getSecretKey() == null) {
                String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
            }
            encryptionInfoTable.put(algorithm, encryptionInfo);
        }
    }

    public static void masterPasswordValidation(String password) throws Exception {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (encryptionInfo.getSecretKey() != null) continue;
            EncryptionUtil.keyDecryptionWithTripleDES(password.toCharArray(), encryptionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EncryptionInfo readSecretKey(String algorithm) throws ClassNotFoundException, IOException {
        FileInputStream bIn = null;
        ObjectInputStream deser = null;
        EncryptionInfo encryptionInfo = null;
        try {
            bIn = new FileInputStream(new File(secretKeyPath));
            deser = new ObjectInputStream(bIn);
            while (!(encryptionInfo = (EncryptionInfo)deser.readObject()).getCipherAlgorithm().equalsIgnoreCase(algorithm)) {
            }
        }
        catch (IOException e) {
            EncryptionInfo encryptionInfo2 = null;
            return encryptionInfo2;
        }
        finally {
            try {
                if (deser != null) {
                    deser.close();
                    deser = null;
                }
            }
            finally {
                if (bIn != null) {
                    bIn.close();
                    bIn = null;
                }
            }
        }
        return encryptionInfo;
    }

    /*
     * Exception decompiling
     */
    public static void loadSecretKeyFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeSecretKey(EncryptionInfo encryptionInfo) {
        FileOutputStream bOut = null;
        ObjectOutputStream ser = null;
        try {
            File secretDir = new File(secretKeyDir);
            if (!secretDir.isDirectory()) {
                secretDir.mkdirs();
            }
            bOut = new FileOutputStream(new File(secretKeyPath));
            ser = new ObjectOutputStream(bOut);
            for (EncryptionInfo info : encryptionInfoTable.values()) {
                if (passwordForSecretKey != null) {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    info = EncryptionUtil.convertFromPlainToEncryptedInfo(info, password);
                }
                ser.writeObject(info);
            }
            if (encryptionInfo != null) {
                if (passwordForSecretKey != null) {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    encryptionInfo = EncryptionUtil.convertFromPlainToEncryptedInfo(encryptionInfo, password);
                }
                ser.writeObject(encryptionInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ser != null) {
                try {
                    ser.close();
                    ser = null;
                }
                catch (IOException ie) {}
            }
            if (bOut != null) {
                try {
                    bOut.close();
                    bOut = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        secretKeyFileName = "security.key";
        cipherTable = new HashMap();
        encryptionInfoTable = new HashMap();
        secretKeyFileObjectTable = new HashMap();
        messageDigestTable = new HashMap();
        SALT_FOR_SECRET_KEY = new byte[]{-35, -49, 95, -63, 44, 0, 121, -1};
        isCreated = false;
        passwordForSecretKey = null;
    }
}

