/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Permission;

public class JACCUtil {
    public static final String JACC_CONTEXT_SUBJECT_KEY = "javax.security.auth.Subject.container";
    public static final String JACC_CONTEXT_SOAP_KEY = "javax.xml.soap.SOAPMessage";
    public static final String JACC_CONTEXT_SERVLET_KEY = "javax.servlet.http.HttpServletRequest";
    public static final String JACC_CONTEXT_EJB_KEY = "javax.ejb.EnterpriseBean";
    public static final String JACC_CONTEXT_EJB_ARGS_KEY = "javax.ejb.arguments";
    public static final String JACC_POLICY_PROVIDER_PROPERTY_KEY = "javax.security.jacc.policy.provider";
    public static final String JACC_POLICY_CONFIGURATION_FACTORY_PROPERTY_KEY = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static boolean useJACC = false;
    public static final String[] allJACCKeys = new String[]{"javax.security.auth.Subject.container", "javax.xml.soap.SOAPMessage", "javax.servlet.http.HttpServletRequest", "javax.ejb.EnterpriseBean", "javax.ejb.arguments"};

    public static boolean isJACCUsed() {
        return useJACC;
    }

    public static boolean isRunningJACCCTS() {
        return System.getProperty("jeus.security.jacc.enable") != null;
    }

    public static void setJACCUsed(boolean usejacc) {
        useJACC = usejacc;
    }

    public static boolean isJACCPermission(Permission perm) {
        return perm != null && perm.getClass().getName().startsWith("javax.security.jacc.");
    }

    public static boolean isJACCPredispatchPermission(Permission perm) {
        return perm != null && (perm.getClass().getName().equals("javax.security.jacc.EJBMethodPermission") || perm.getClass().getName().equals("javax.security.jacc.WebResourcePermission"));
    }

    public static boolean isJACCCallerInRolePermission(Permission perm) {
        return JACCUtil.isJACCEJBCallerInRolePermission(perm) || JACCUtil.isJACCWebUserInRolePermission(perm);
    }

    public static boolean isJACCEJBCallerInRolePermission(Permission perm) {
        return perm != null && perm.getClass().getName().equals("javax.security.jacc.EJBRoleRefPermission");
    }

    public static boolean isJACCWebUserInRolePermission(Permission perm) {
        return perm != null && perm.getClass().getName().equals("javax.security.jacc.WebRoleRefPermission");
    }
}

