/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.ServiceException;
import jeus.security.resource.DefaultCache;
import jeus.security.resource.LRUCache;
import jeus.security.resource.SecurityCache;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.JeusMessage_Security;
import jeus.security.util.LoggerUtil;

public class PolicyManager {
    private SecurityCache policyCache;

    public PolicyManager(int min, int max, long timeout) {
        if (timeout == -1L) {
            this.policyCache = new LRUCache(min, max, true);
        } else {
            this.policyCache = new DefaultCache(min, max, timeout);
            this.policyCache.create();
            this.policyCache.start();
        }
    }

    public void stop() {
        this.policyCache.stop();
    }

    public void clear() {
        this.policyCache.destroy();
    }

    public boolean isEmpty() {
        return this.policyCache.size() <= 0;
    }

    public Policy getPolicy(String contextId) throws PolicyNotExistsException, ServiceException {
        if (contextId == null) {
            throw new PolicyNotExistsException("Failed getting Policy: context id is null");
        }
        Policy p = (Policy)this.policyCache.get(contextId);
        if (p == null) {
            List keys = this.policyCache.getValidKeys();
            String domain = Domain.getCurrentDomain().getName();
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._39_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._39_LEVEL, JeusMessage_Security._39, (Object[])new String[]{domain, keys.toString()});
            }
            throw new PolicyNotExistsException("Failed getting policy: the Policy does not exist : " + domain + "/" + contextId);
        }
        return p;
    }

    public Set getContextIds() {
        HashSet result = new HashSet();
        result.addAll(this.policyCache.getValidKeys());
        return result;
    }

    public synchronized void addPolicy(Policy policy) throws ServiceException {
        if (policy == null) {
            throw new ServiceException("Failed adding Policy: Policy to add is null");
        }
        Policy p = this.getPolicyFromTable(policy);
        if (p == null) {
            this.addPolicyToTable(policy);
        } else {
            p.add(policy);
            this.addPolicyToTable(p);
        }
    }

    public synchronized void removePolicy(Policy policy) throws PolicyNotExistsException, ServiceException {
        if (policy == null) {
            throw new ServiceException("Failed removing Policy: Policy to remove is null");
        }
        Policy p = this.getPolicyFromTable(policy);
        if (p == null) {
            throw new PolicyNotExistsException("Failed removing Policy: Policy to remove does not exist");
        }
        p.remove(policy);
        this.removePolicyFromTable(p);
        this.addPolicyToTable(p);
    }

    public synchronized void removePolicy(String contextId) throws PolicyNotExistsException, ServiceException {
        if (contextId == null) {
            throw new ServiceException("Failed removing Policy: context id is null");
        }
        Policy p = (Policy)this.policyCache.get(contextId);
        if (p == null) {
            throw new PolicyNotExistsException("Failed removing Policy: Policy for context id " + contextId + " does not exist");
        }
        this.policyCache.remove(contextId);
    }

    public Policy[] getPoliciesAsArray() {
        return this.policyCache.values().toArray(new Policy[0]);
    }

    public void addPoliciesFromArray(Policy[] policies) throws ServiceException {
        for (int i = 0; i < policies.length; ++i) {
            this.addPolicy(policies[i]);
        }
    }

    private Policy getPolicyFromTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            Policy p = (Policy)this.policyCache.get(id);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private void addPolicyToTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            this.policyCache.put(id, policy);
        }
    }

    private void removePolicyFromTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            this.policyCache.remove(id);
        }
    }

    public static boolean authorize(String contextId, Policy policy, Permission permission, Principal[] principals) {
        return PolicyManager.authorize(contextId, policy, permission, principals, null, null);
    }

    public static boolean authorize(String contextId, Policy policy, Permission permission, Principal[] principals, java.security.Policy delegatePolicy, ProtectionDomain pdDomain) {
        if (policy == null && delegatePolicy == null) {
            return false;
        }
        if (policy != null) {
            if (principals != null) {
                PermissionMap.CheckResult result = policy.checkPermission(contextId, principals, permission);
                if (result == PermissionMap.EXCLUDED) {
                    return false;
                }
                if (result.isGranted()) {
                    return true;
                }
                if (result == PermissionMap.UNCHECKED) {
                    return true;
                }
            } else {
                PermissionMap.CheckResult result = policy.checkPermission(contextId, permission);
                if (result == PermissionMap.EXCLUDED) {
                    return false;
                }
                if (result.isGranted()) {
                    return true;
                }
                if (result == PermissionMap.UNCHECKED) {
                    return true;
                }
            }
        }
        if (delegatePolicy != null) {
            return delegatePolicy.implies(pdDomain, permission);
        }
        return false;
    }
}

