/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class SubjectActions {
    public static LoginContext createLoginContext(String securityDomain, Subject subject, CallbackHandler handler) throws LoginException {
        LoginContextAction action = new LoginContextAction(securityDomain, subject, handler);
        try {
            LoginContext lc = (LoginContext)AccessController.doPrivileged(action);
            return lc;
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException(ex.getMessage());
        }
    }

    private static class LoginContextAction
    implements PrivilegedExceptionAction {
        String securityDomain;
        Subject subject;
        CallbackHandler handler;

        LoginContextAction(String securityDomain, Subject subject, CallbackHandler handler) {
            this.securityDomain = securityDomain;
            this.subject = subject;
            this.handler = handler;
        }

        public Object run() throws Exception {
            LoginContext lc = null;
            lc = this.handler == null ? new LoginContext(this.securityDomain, this.subject) : new LoginContext(this.securityDomain, this.subject, this.handler);
            return lc;
        }
    }

    private static class CopySubjectAction
    implements PrivilegedAction {
        Subject fromSubject;
        Subject toSubject;
        boolean setReadOnly;

        CopySubjectAction(Subject fromSubject, Subject toSubject, boolean setReadOnly) {
            this.fromSubject = fromSubject;
            this.toSubject = toSubject;
            this.setReadOnly = setReadOnly;
        }

        public Object run() {
            Set<Principal> principals = this.fromSubject.getPrincipals();
            Set<Principal> principals2 = this.toSubject.getPrincipals();
            Iterator<Object> iter = principals.iterator();
            while (iter.hasNext()) {
                principals2.add(iter.next());
            }
            Set<Object> privateCreds = this.fromSubject.getPrivateCredentials();
            Set<Object> privateCreds2 = this.toSubject.getPrivateCredentials();
            iter = privateCreds.iterator();
            while (iter.hasNext()) {
                privateCreds2.add(iter.next());
            }
            Set<Object> publicCreds = this.fromSubject.getPublicCredentials();
            Set<Object> publicCreds2 = this.toSubject.getPublicCredentials();
            iter = publicCreds.iterator();
            while (iter.hasNext()) {
                publicCreds2.add(iter.next());
            }
            if (this.setReadOnly) {
                this.toSubject.setReadOnly();
            }
            return null;
        }
    }
}

