/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jeus.security.util.TimedHashMap;

public class TimedLinkedHashMap
extends TimedHashMap {
    private transient Entry header;
    private final boolean accessOrder;
    private int fixed;

    public TimedLinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public TimedLinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public TimedLinkedHashMap() {
        this.accessOrder = false;
    }

    public TimedLinkedHashMap(Map m) {
        super(m);
        this.accessOrder = false;
    }

    public TimedLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    public TimedLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, int fixed) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
        this.fixed = fixed;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    void transfer(TimedHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = TimedLinkedHashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    void addEntry(int hash, Object key, Object value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, Object value, int bucketIndex) {
        Entry e = new Entry(hash, key, value, this.table[bucketIndex]);
        this.table[bucketIndex] = e;
        e.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.fixed;
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((TimedLinkedHashMap)TimedLinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = TimedLinkedHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != TimedLinkedHashMap.this.header;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TimedLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TimedLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = TimedLinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (TimedLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == TimedLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            this.nextEntry = e.after;
            return e;
        }
    }

    private static class Entry
    extends TimedHashMap.Entry {
        Entry before;
        Entry after;

        Entry(int hash, Object key, Object value, TimedHashMap.Entry next) {
            super(hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(TimedHashMap m) {
            TimedLinkedHashMap lm = (TimedLinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        void recordRemoval(HashMap m) {
            this.remove();
        }
    }
}

