/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import jeus.xml.binding.util.JAXBContextFactory;

public abstract class XMLConverter {
    private JAXBContext context;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    public XMLConverter(String contextPath) throws Exception {
        this.context = JAXBContextFactory.getContext(contextPath);
        this.unmarshaller = this.context.createUnmarshaller();
        this.marshaller = this.context.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
    }

    public synchronized boolean isValidating() throws Exception {
        return true;
    }

    public synchronized void setValidation(boolean validate) throws Exception {
    }

    public synchronized Object unmarshal(Object contentTree) throws Exception {
        return this.fromXMLTree(contentTree);
    }

    public synchronized Object unmarshal(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        return this.unmarshal(fis);
    }

    public synchronized Object unmarshal(InputStream is) throws Exception {
        return this.unmarshal(((JAXBElement)this.unmarshaller.unmarshal(is)).getValue());
    }

    public synchronized void marshal(Object object, File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        this.marshaller.marshal(this.marshal(object), (OutputStream)fos);
    }

    public synchronized void marshal(Object object, OutputStream os) throws Exception {
        this.marshaller.marshal(this.marshal(object), os);
    }

    public final Object marshal(Object object) throws Exception {
        return this.toXMLTree(object, null);
    }

    public synchronized Object marshal(Object object, Object tree) throws Exception {
        return this.toXMLTree(object, tree);
    }

    protected abstract Object fromXMLTree(Object var1) throws Exception;

    protected abstract Object toXMLTree(Object var1, Object var2) throws Exception;
}

