/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import jeus.util.CompoundEnumeration;

public class RootClassLoader
extends URLClassLoader {
    private URLClassLoader loader;
    public static final URL[] DUMMY_URL = new URL[0];
    private URL[] originalURLs = null;

    public RootClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.originalURLs = urls;
    }

    public void registerEJBRootClassLoader(URLClassLoader loader) {
        this.loader = loader;
    }

    public URLClassLoader removeEJBRootClassLoader() {
        URLClassLoader tmp = this.loader;
        this.loader = null;
        return tmp;
    }

    public URLClassLoader getEJBRootClassLoader() {
        return this.loader;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.loader == null || className.startsWith("java.") || className.startsWith("jeus.") || className.startsWith("javax.")) {
            Class<?> c = super.loadClass(className, resolve);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        Class<?> classObj = this.loader.loadClass(className);
        if (resolve) {
            this.resolveClass(classObj);
        }
        return classObj;
    }

    public Class loadClassFromSuper(String className, boolean resolve) {
        try {
            return super.loadClass(className, resolve);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public URL getResource(String name) {
        if (this.loader == null) {
            return super.getResource(name);
        }
        return this.loader.getResource(name);
    }

    public URL getResourceFromSuper(String name) {
        return super.getResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        if (this.loader == null) {
            return super.findResources(name);
        }
        Enumeration[] temp = new Enumeration[]{super.findResources(name), this.loader.findResources(name)};
        return new CompoundEnumeration(temp);
    }

    public URL[] getURLs() {
        return DUMMY_URL;
    }

    public URL[] getOriginalURLs() {
        return this.originalURLs;
    }
}

