/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import jeus.descriptor.jeusserver.EngineContainerDescriptor;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.security.util.LoginUtil;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.ContainerManagerService;
import jeus.server.util.EngineSync;
import jeus.util.CUtility;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusEngineContainerProperties;
import jeus.util.properties.JeusManagerProperties;

public class VirtualTerminal
extends Thread {
    public static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    public static final String magicNum = "973630";
    private static final int RETRY_TO = 10000;
    protected ContainerManagerService containerManager;
    private Process container;
    private BufferedInputStream input;
    private BufferedInputStream error;
    private String nodeName;
    private String name;
    private Vector enginelist;
    private EngineContainerDescriptor ecdesc;
    private EngineSync sync = null;
    private ErrorTerminal errorTerminal;
    private J2EEServerMBean controller;
    private int pid = -1;
    private byte[] buffer = new byte[51200];
    private boolean running = false;
    private boolean shutdown = false;
    private boolean killCommand = false;
    private boolean reforkCommand = false;

    public VirtualTerminal(Process container, String group, EngineContainerDescriptor ecdesc, EngineSync sync, ContainerManagerService containerManager) {
        super("jeus.server.VirturalTerminal");
        this.container = container;
        this.ecdesc = ecdesc;
        this.input = new BufferedInputStream(container.getInputStream(), 51200);
        this.error = new BufferedInputStream(container.getErrorStream(), 51200);
        this.containerManager = containerManager;
        this.nodeName = group;
        this.name = ecdesc.getName();
        this.sync = sync;
    }

    public VirtualTerminal(String name, ContainerManagerService containerManager) {
        super(name);
        this.containerManager = containerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (!this.waitForContainer()) {
                return;
            }
            this.containerManager.registerContainer(this.nodeName, this.name, this.enginelist, this);
            this.sync.success(this.name);
            if (logger.isLoggable(JeusMessage_Manager._303_LEVEL)) {
                logger.log(JeusMessage_Manager._303_LEVEL, JeusMessage_Manager._303, (Object[])new String[]{this.name, Integer.toString(this.pid)});
            }
            this.running = true;
            this.errorTerminal = new ErrorTerminal(this.error);
            this.errorTerminal.setDaemon(true);
            this.errorTerminal.start();
        }
        catch (Throwable t) {
            block17: {
                if (logger.isLoggable(JeusMessage_Manager._302_LEVEL)) {
                    logger.log(JeusMessage_Manager._302_LEVEL, JeusMessage_Manager._302, (Object)this.name, t);
                }
                try {
                    this.containerManager.containerFailure(this);
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_Manager._304_LEVEL)) break block17;
                    logger.log(JeusMessage_Manager._304_LEVEL, JeusMessage_Manager._304, e);
                }
            }
            this.sync.fail();
            return;
        }
        try {
            this.writeTerminalRunning();
        }
        catch (Throwable ex) {
            VirtualTerminal virtualTerminal = this;
            synchronized (virtualTerminal) {
                if (this.running) {
                    if (logger.isLoggable(JeusMessage_Manager._305_LEVEL)) {
                        logger.log(JeusMessage_Manager._305_LEVEL, JeusMessage_Manager._305, (Object)this.name, ex);
                    }
                    try {
                        this.kill(false);
                    }
                    catch (JeusServerException jeusServerException) {
                        // empty catch block
                    }
                    this.reforkContainer();
                } else {
                    this.shutdown = true;
                    this.notifyAll();
                }
            }
        }
    }

    private boolean waitForContainer() throws IOException {
        StringBuffer containerErrMsgBuffer = new StringBuffer();
        boolean beforeFirstMagicNum = true;
        while (true) {
            int avail;
            if ((avail = this.input.available()) > 0) {
                this.writeTerminalInit(avail);
                continue;
            }
            avail = this.error.available();
            if (avail > 0) {
                int len = this.error.read(this.buffer, 0, avail > this.buffer.length ? this.buffer.length : avail);
                String msg = new String(this.buffer, 0, len);
                containerErrMsgBuffer.append(msg);
                int magicIdx = containerErrMsgBuffer.toString().indexOf(magicNum);
                if (magicIdx < 0) {
                    logger.directLog2(msg, true);
                    continue;
                }
                if (beforeFirstMagicNum) {
                    beforeFirstMagicNum = false;
                    if ((magicIdx = (containerErrMsgBuffer = new StringBuffer(containerErrMsgBuffer.substring(magicIdx + magicNum.length()))).toString().indexOf(magicNum)) < 0) continue;
                }
                if ((msg = containerErrMsgBuffer.substring(0, magicIdx)).startsWith("ok")) {
                    this.parseResults(msg);
                    return true;
                }
                if (!msg.startsWith("error")) continue;
                this.containerManager.containerFailure(this);
                this.sync.fail();
                if (logger.isLoggable(JeusMessage_Manager1._461_LEVEL)) {
                    logger.log(JeusMessage_Manager1._461_LEVEL, JeusMessage_Manager1._461, (Object)this.name);
                }
                return false;
            }
            try {
                this.container.exitValue();
                this.containerManager.containerFailure(this);
                this.sync.fail();
                if (logger.isLoggable(JeusMessage_Manager1._462_LEVEL)) {
                    logger.log(JeusMessage_Manager1._462_LEVEL, JeusMessage_Manager1._462, (Object)this.name);
                }
                return false;
            }
            catch (IllegalThreadStateException ex) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException exc) {
                }
                continue;
            }
            break;
        }
    }

    private void writeTerminalInit(int avail) throws IOException {
        int len = this.input.read(this.buffer, 0, avail > this.buffer.length ? this.buffer.length : avail);
        logger.directLog2(new String(this.buffer, 0, len), JeusEngineContainerProperties.flushing);
    }

    private void parseResults(String msg) {
        block3: {
            try {
                int idx;
                this.pid = Integer.parseInt(msg.substring(3, msg.indexOf(41)));
                this.enginelist = new Vector();
                String engines = msg.substring(msg.indexOf(91) + 1, msg.indexOf(93));
                while ((idx = engines.indexOf(44)) != -1) {
                    this.enginelist.add(engines.substring(0, idx));
                    engines = engines.substring(idx + 1);
                }
                this.enginelist.add(engines);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_Manager._310_LEVEL)) break block3;
                logger.log(JeusMessage_Manager._310_LEVEL, JeusMessage_Manager._310, (Object[])new String[]{this.name, msg}, t);
            }
        }
    }

    private void writeTerminalRunning() throws IOException {
        while (true) {
            try {
                while (true) {
                    int len;
                    if ((len = this.input.read(this.buffer)) == -1) {
                        throw new JeusServerException(JeusMessage_Manager._337);
                    }
                    logger.directLog2(new String(this.buffer, 0, len), JeusEngineContainerProperties.flushing);
                }
            }
            catch (OutOfMemoryError er) {
                System.gc();
                System.runFinalization();
                try {
                    if (!logger.isLoggable(JeusMessage_Manager._309_LEVEL)) continue;
                    logger.log(JeusMessage_Manager._309_LEVEL, JeusMessage_Manager._309);
                    continue;
                }
                catch (OutOfMemoryError err) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reforkContainer() {
        block13: {
            block11: {
                if (this.reforkCommand) {
                    return;
                }
                this.reforkCommand = true;
                logger.log(JeusMessage_Manager._307_LEVEL, JeusMessage_Manager._307, (Object)this.name);
                try {
                    String msg = ErrorMsgManager.getLocalizedString((int)JeusMessage_Manager._307, (Object)this.name);
                    if (logger.isLoggable(Level.SEVERE)) {
                        JeusServer.logger.sendEmailNotification(Level.SEVERE, msg);
                    }
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_Manager._257_LEVEL)) break block11;
                    logger.log(JeusMessage_Manager._257_LEVEL, JeusMessage_Manager._257, e);
                }
            }
            boolean restarted = false;
            if (JeusEngineContainerProperties.CONTAINER_RESTART) {
                LoginUtil.loginCodeSubjectWithRuntimeException();
                try {
                    restarted = this.containerManager.startContainer(this.nodeName, this.name, this.ecdesc, this.enginelist, true);
                }
                finally {
                    LoginUtil.logoutWithRuntimeException();
                }
            }
            if (!restarted) {
                try {
                    this.containerManager.removeVirtualTerminal(this.nodeName, this.name);
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_Manager._308_LEVEL)) break block13;
                    logger.log(JeusMessage_Manager._308_LEVEL, JeusMessage_Manager._308, new Object[]{this.nodeName, this.name}, e);
                }
            }
        }
    }

    public synchronized void waitForContainerDown(Runnable r) {
        this.down();
        Thread t = new Thread(r);
        t.start();
        try {
            this.wait(JeusManagerProperties.DOWN_TIMEOUT_PER_CONTAINER);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!this.shutdown) {
            try {
                this.kill();
            }
            catch (JeusServerException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void down() {
        this.running = false;
        if (this.errorTerminal != null) {
            this.errorTerminal.down();
        }
    }

    public void kill() throws JeusServerException {
        this.kill(false);
    }

    public synchronized void kill(boolean dumpThread) throws JeusServerException {
        int result;
        if (this.killCommand) {
            return;
        }
        this.killCommand = true;
        if (dumpThread) {
            CUtility.dumpThreadStack((int)this.pid);
        }
        if ((result = CUtility.kill((int)this.pid)) != 0) {
            throw new JeusServerException(JeusMessage_Manager._311, new String[]{this.name, String.valueOf(this.pid)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAlive() {
        if (this.controller == null) {
            MEJBUtility utility = null;
            try {
                utility = MEJBUtility.getMEJBUtility();
                this.controller = JMXUtility.getProxy((MBeanServerConnection)utility, JMXUtility.queryJ2EEServer((MBeanServerConnection)utility, this.name), J2EEServerMBean.class, false);
            }
            catch (Exception e) {
                throw new JeusRuntimeException((Throwable)e);
            }
        }
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            if (logger.isLoggable(JeusMessage_Manager._314_LEVEL)) {
                logger.log(JeusMessage_Manager._314_LEVEL, JeusMessage_Manager._314, (Object)this.name);
            }
            this.controller.checkAlive();
        }
        catch (Throwable throwable) {
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public int getPID() {
        return this.pid;
    }

    public Process getContainer() {
        return this.container;
    }

    public String getContainerName() {
        return this.name;
    }

    class ErrorTerminal
    extends Thread {
        private byte[] errbuffer;
        private InputStream err;
        private boolean running;

        public ErrorTerminal(InputStream err) {
            super("jeus.server.ErrorTerminal");
            this.errbuffer = new byte[51200];
            this.running = false;
            this.err = err;
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    int len;
                    if ((len = this.err.read(this.errbuffer)) == -1) {
                        throw new JeusException(JeusMessage_Manager._338);
                    }
                    logger.directLog2(new String(this.errbuffer, 0, len), true);
                }
            }
            catch (Throwable e) {
                VirtualTerminal virtualTerminal = VirtualTerminal.this;
                synchronized (virtualTerminal) {
                    if (this.running) {
                        if (logger.isLoggable(JeusMessage_Manager._315_LEVEL)) {
                            logger.log(JeusMessage_Manager._315_LEVEL, JeusMessage_Manager._315, (Object)VirtualTerminal.this.name, e);
                        }
                        try {
                            VirtualTerminal.this.kill(false);
                        }
                        catch (JeusServerException jeusServerException) {
                            // empty catch block
                        }
                        VirtualTerminal.this.reforkContainer();
                    } else {
                        VirtualTerminal.this.shutdown = true;
                        VirtualTerminal.this.notifyAll();
                    }
                }
                return;
            }
        }

        private void down() {
            this.running = false;
        }
    }
}

