/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.cluster;

import java.util.Map;
import jeus.server.cluster.BeaconReceiver;
import jeus.server.cluster.NodeEntry;
import jeus.util.properties.JeusNodeClusterProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconConnector
extends Thread {
    private static final NodeEntry[] DUMMY_NODE_ENTRY = new NodeEntry[0];
    private Map<String, NodeEntry> primarys;
    private boolean beaconSW;
    private Object ready = new Object();
    private BeaconReceiver receiver;

    public BeaconConnector(BeaconReceiver receiver) {
        super("jeus.server.cluster.BeaconConnector");
        this.setDaemon(true);
        this.receiver = receiver;
    }

    @Override
    public void run() {
        Object object = this.ready;
        synchronized (object) {
            while (true) {
                if (this.beaconSW) {
                    this.beaconOn();
                    try {
                        BeaconConnector.sleep(JeusNodeClusterProperties.CLUSTER_CHECK_TIMEOUT);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    BeaconConnector.interrupted();
                    continue;
                }
                try {
                    this.ready.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(Map<String, NodeEntry> primarys) {
        Object object = this.ready;
        synchronized (object) {
            this.primarys = primarys;
            this.beaconSW = true;
            this.ready.notify();
        }
    }

    public void unexport() {
        this.beaconSW = false;
        this.interrupt();
    }

    private void beaconOn() {
        if (this.primarys.size() == 1) {
            return;
        }
        NodeEntry.checkStatus(this.primarys.values().toArray(DUMMY_NODE_ENTRY), this.receiver);
    }
}

