/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.cluster;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.cluster.NodeEntry;
import jeus.server.cluster.NodeServerEntry;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusNodeClusterProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeaconReceiver
implements ConnectionListenerFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.clustering");
    private final JeusServer server;
    private Map<String, NodeEntry> nodeEntryList;
    private Endpoint endpoint;

    public BeaconReceiver(JeusServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Map<String, NodeEntry> nodeEntryList) throws JeusServerException {
        try {
            this.nodeEntryList = nodeEntryList;
            BeaconReceiver beaconReceiver = this;
            synchronized (beaconReceiver) {
                if (this.endpoint == null) {
                    this.endpoint = new Endpoint("BeaconHandler", JeusIOComponentCreator.DEFAULT_CREATOR, (SocketID)JeusServer.clusterInfo.getLocalNode("BeaconHandler"), (ConnectionListenerFactory)this);
                    this.endpoint.setConnectTimeout(JeusNodeClusterProperties.CLUSTER_CONNECT_TIMEOUT);
                    try {
                        this.endpoint.export();
                        if (logger.isLoggable(JeusMessage_Manager1._511_LEVEL)) {
                            logger.log(JeusMessage_Manager1._511_LEVEL, JeusMessage_Manager1._511);
                        }
                    }
                    catch (IOException e) {
                        throw new JeusRuntimeException((Throwable)e);
                    }
                }
            }
            beaconReceiver = this;
            synchronized (beaconReceiver) {
                this.notifyAll();
            }
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._352, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unexport() throws IOException {
        BeaconReceiver beaconReceiver = this;
        synchronized (beaconReceiver) {
            if (this.endpoint != null) {
                this.endpoint.unexport();
                this.endpoint = null;
                if (logger.isLoggable(JeusMessage_Manager1._512_LEVEL)) {
                    logger.log(JeusMessage_Manager1._512_LEVEL, JeusMessage_Manager1._512);
                }
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeEntry getNodeEntry(SocketID socketID) {
        String nodeName = VirtualDNS.getVirtualHostName(socketID.getHost() + ":" + socketID.getBasePort());
        Map<String, NodeEntry> map = this.nodeEntryList;
        synchronized (map) {
            NodeEntry nodeEntry = this.nodeEntryList.get(nodeName);
            if (nodeEntry != null) {
                return nodeEntry;
            }
            if (logger.isLoggable(JeusMessage_Manager1._414_LEVEL)) {
                logger.log(JeusMessage_Manager1._414_LEVEL, JeusMessage_Manager1._414, (Object)nodeName);
            }
            nodeEntry = new NodeEntry(nodeName, this.server.getServerName(), this.server, false);
            this.nodeEntryList.put(nodeName, nodeEntry);
            return nodeEntry;
        }
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        if (logger.isLoggable(JeusMessage_Manager1._412_LEVEL)) {
            logger.log(JeusMessage_Manager1._412_LEVEL, JeusMessage_Manager1._412, (Object)socket);
        }
        try {
            return new NodeServerEntry(socket, this);
        }
        catch (IOException e) {
            throw new JeusRuntimeException((Throwable)e);
        }
    }

    public SocketStream connect(NodeEntry entry) throws ConnectorException {
        return this.endpoint.getSocketStream((SocketID)entry, 1, null, 0, 0);
    }
}

