/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.enginecontainer;

import java.util.Vector;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.security.util.LoginUtil;
import jeus.server.VirtualTerminal;
import jeus.server.enginecontainer.EngineContainer;
import jeus.server.enginecontainer.EngineContainerException;
import jeus.server.service.ContainerManagerService;
import jeus.server.util.EngineSync;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_Manager;

public class DefaultEngineContainer
extends EngineContainer {
    public static DefaultEngineContainer defaultContainer;

    public DefaultEngineContainer(String[] args) throws EngineContainerException {
        JeusMainDescriptor mdesc = DefaultEngineContainer.initConfiguration(true, args);
        this.init(args, mdesc);
    }

    public void restartEngine(String engineName) throws EngineContainerException {
        throw new EngineContainerException(JeusMessage_Manager._103);
    }

    public static VirtualTerminal createContainer(String containerName, Vector enginelist, EngineSync sync, int conId, ContainerManagerService containerManager) throws EngineContainerException {
        try {
            BootThread thread = new BootThread(containerName, enginelist, sync, conId, containerManager);
            thread.start();
            return thread;
        }
        catch (Throwable t) {
            throw new EngineContainerException(JeusMessage_Manager.MGR_71, containerName, t);
        }
    }

    public static class BootThread
    extends VirtualTerminal {
        private String containerName;
        private Vector enginelist;
        private EngineSync sync;
        private int conId;

        public BootThread(String containerName, Vector enginelist, EngineSync sync, int conId, ContainerManagerService containerManager) {
            super("jeus.server.enginecontainer.DefaultEngineContainer.BootThread", containerManager);
            this.containerName = containerName;
            this.enginelist = enginelist;
            this.sync = sync;
            this.conId = conId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            try {
                System.setProperty("jeus.ejb.operationTimeout", Integer.toString(300000));
                String[] args = new String[this.enginelist.size() + 1];
                args[0] = this.containerName;
                for (int i = 0; i < this.enginelist.size(); ++i) {
                    args[i + 1] = (String)this.enginelist.elementAt(i);
                }
                defaultContainer = new DefaultEngineContainer(args);
                if (logger.isLoggable(JeusMessage_Manager._100_LEVEL)) {
                    logger.log(JeusMessage_Manager._100_LEVEL, JeusMessage_Manager._100, (Object)this.containerName);
                }
                Vector engines = (Vector)defaultContainer.getEngineList().clone();
                this.containerManager.registerContainer(StringUtil.getNodeNameFromContainerName((String)this.containerName), this.containerName, engines, this);
                this.sync.success(this.containerName);
                String enginelist = "[";
                for (int i = 0; i < engines.size(); ++i) {
                    if (i != 0) {
                        enginelist = enginelist + ",";
                    }
                    enginelist = enginelist + (String)engines.elementAt(i);
                }
                enginelist = enginelist + "]";
                if (logger.isLoggable(JeusMessage_Manager._101_LEVEL)) {
                    logger.log(JeusMessage_Manager._101_LEVEL, JeusMessage_Manager._101, new Object[]{this.containerName, enginelist});
                }
            }
            catch (Throwable ex) {
                try {
                    this.containerManager.containerFailure(this);
                }
                catch (Throwable e) {
                    logger.log(JeusMessage_Manager._104_LEVEL, JeusMessage_Manager._104, e);
                }
                this.sync.fail();
                logger.log(JeusMessage_Manager._102_LEVEL, JeusMessage_Manager._102, (Object)this.containerName, ex);
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
        }
    }
}

