/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.ejb.webserver.WebServer;
import jeus.ejb.webserver.WebServerException;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServerException;
import jeus.server.service.ClassFTPServiceMBean;
import jeus.server.service.JEUSService;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.JeusNodeType;

public class ClassFTPService
extends JEUSService
implements ClassFTPServiceMBean {
    private static boolean isClassFTPStarted = false;
    private WebServer wserver;
    private ResourcePermission classFtpPermission;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ClassFTPService mo = new ClassFTPService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "ClassFTPService");
    }

    protected void makePermissions() {
        super.makePermissions();
        this.classFtpPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"classftp");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.classFtpPermission);
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        try {
            if (desc.getClassFTP() && !isClassFTPStarted) {
                this.wserver = new WebServer(this.myObjectName);
                this.wserver.export();
                isClassFTPStarted = true;
                if (logger.isLoggable(JeusMessage_Manager._114_LEVEL)) {
                    logger.log(JeusMessage_Manager._114_LEVEL, JeusMessage_Manager._114);
                }
            }
        }
        catch (WebServerException e) {
            block6: {
                try {
                    this.wserver.unexport();
                    this.wserver = null;
                }
                catch (Throwable ex3) {
                    if (!logger.isLoggable(JeusMessage_Manager._115_LEVEL)) break block6;
                    logger.log(JeusMessage_Manager._115_LEVEL, JeusMessage_Manager._115, ex3);
                }
            }
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._116, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws JeusServerException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.classFtpPermission);
        try {
            if (this.wserver != null) {
                this.wserver.unexport();
                this.wserver = null;
            }
        }
        catch (Throwable ex1) {
            if (logger.isLoggable(JeusMessage_Manager._115_LEVEL)) {
                logger.log(JeusMessage_Manager._115_LEVEL, JeusMessage_Manager._115, ex1);
            }
        }
        finally {
            isClassFTPStarted = false;
            this.destroyMBean();
        }
    }

    public void startService(JeusNodeType nodeType) throws JeusServerException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.classFtpPermission);
        try {
            if (nodeType.isClassFtp().booleanValue() && !isClassFTPStarted) {
                this.wserver = new WebServer(this.myObjectName);
                this.wserver.export();
                isClassFTPStarted = true;
                if (logger.isLoggable(JeusMessage_Manager._114_LEVEL)) {
                    logger.log(JeusMessage_Manager._114_LEVEL, JeusMessage_Manager._114);
                }
            }
        }
        catch (WebServerException e) {
            block6: {
                try {
                    this.wserver.unexport();
                    this.wserver = null;
                }
                catch (Throwable ex3) {
                    if (!logger.isLoggable(JeusMessage_Manager._115_LEVEL)) break block6;
                    logger.log(JeusMessage_Manager._115_LEVEL, JeusMessage_Manager._115, ex3);
                }
            }
            this.destroyMBean();
            throw new JeusServerException(JeusMessage_Manager._116, (Throwable)((Object)e));
        }
    }

    public String getJeusType() {
        return "ClassFTPService";
    }
}

