/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.spi.LoginService;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.cluster.BeaconConnector;
import jeus.server.cluster.BeaconReceiver;
import jeus.server.cluster.NodeEntry;
import jeus.server.service.ClusterServiceMBean;
import jeus.server.service.JEUSService;
import jeus.util.message.JeusMessage_Manager;

public class ClusterService
extends JEUSService
implements ClusterServiceMBean {
    private BeaconReceiver receiver;
    private BeaconConnector connector;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ClusterService mo = new ClusterService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "ClusterService");
    }

    public void startService(Object obj) throws JeusServerException {
        Map<String, NodeEntry> nodeEntryList;
        block5: {
            LoginService.checkCodeSubject();
            JeusServer server = (JeusServer)obj;
            try {
                this.receiver = new BeaconReceiver(server);
            }
            catch (Throwable ex) {
                this.destroyMBean();
                throw new JeusServerException(JeusMessage_Manager._117, ex);
            }
            this.connector = new BeaconConnector(this.receiver);
            this.connector.setPriority(Thread.currentThread().getPriority());
            this.connector.start();
            nodeEntryList = server.getPrimarys();
            try {
                this.receiver.export(nodeEntryList);
                if (logger.isLoggable(JeusMessage_Manager._119_LEVEL)) {
                    logger.log(JeusMessage_Manager._119_LEVEL, JeusMessage_Manager._119);
                }
            }
            catch (JeusServerException e) {
                if (!logger.isLoggable(JeusMessage_Manager._121_LEVEL)) break block5;
                logger.log(JeusMessage_Manager._121_LEVEL, JeusMessage_Manager._121, (Throwable)((Object)e));
            }
        }
        this.connector.launch(nodeEntryList);
    }

    public void stopService() throws JeusServerException {
        this.stopServiceInternal();
        this.destroyMBean();
    }

    private void stopServiceInternal() {
        block2: {
            try {
                this.connector.unexport();
                this.receiver.unexport();
            }
            catch (Throwable ex1) {
                if (!logger.isLoggable(JeusMessage_Manager._122_LEVEL)) break block2;
                logger.log(JeusMessage_Manager._122_LEVEL, JeusMessage_Manager._122, ex1);
            }
        }
    }

    public String getJeusType() {
        return "ClusterService";
    }

    public void restartService() throws JeusServerException {
        this.stopServiceInternal();
        this.startService(JeusServer.server);
    }
}

