/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.security.spi.LoginService;
import jeus.server.ContainerMonitorThread;
import jeus.server.JeusServer;
import jeus.server.JeusServerException;
import jeus.server.service.ContainerMonitorServiceMBean;
import jeus.server.service.JEUSService;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.properties.JeusManagerProperties;

public class ContainerMonitorService
extends JEUSService
implements ContainerMonitorServiceMBean,
NotificationListener {
    private ContainerMonitorThread containerMonitor;
    private JEUSManagerMBean manger;

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        ContainerMonitorService mo = new ContainerMonitorService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "ContainerMonitorService");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        JeusServer server = (JeusServer)obj;
        if (JeusManagerProperties.CONTAINER_CHECK_ALIVE) {
            this.containerMonitor = new ContainerMonitorThread(server.getContainerManagerServiceName());
            this.containerMonitor.start();
            this.manger = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, JEUSManagerMBean.class, true);
            try {
                this.manger.addNotificationListener(this, null, null);
            }
            catch (Throwable e) {
                this.destroyMBean();
                throw new JeusServerException(JeusMessage_Manager._118, e);
            }
        }
    }

    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        if (this.manger != null) {
            try {
                this.manger.removeNotificationListener(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.destroyMBean();
    }

    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("jeus.server.started".equals(type)) {
            this.containerMonitor.export();
            logger.log(JeusMessage_Manager._161_LEVEL, JeusMessage_Manager._161);
        } else if ("jeus.server.stopped".equals(type)) {
            try {
                this.containerMonitor.unexport();
                logger.log(JeusMessage_Manager._163_LEVEL, JeusMessage_Manager._163);
            }
            catch (Throwable ex1) {
                logger.log(JeusMessage_Manager._162_LEVEL, JeusMessage_Manager._162, ex1);
            }
        }
    }

    public String getJeusType() {
        return "ContainerMonitorService";
    }
}

