/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jeus.external.InvalidPropertyException;
import jeus.external.ResourceBootstrapper;
import jeus.server.JeusServerException;
import jeus.xml.binding.jeusDD.ExternalResourceType;
import jeus.xml.binding.jeusDD.HierarchicalPropertyType;
import jeus.xml.binding.jeusDD.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalResourceHandler {
    private Hashtable<String, ExternalResourceType> externalResourceMap = new Hashtable();
    private static final String BOOTSTRAPPER_KEY = "BOOTSTRAPPER";

    public void bindResources(List<ExternalResourceType> resources) throws JeusServerException {
        for (ExternalResourceType resource : resources) {
            ResourceBootstrapper bootstrapper = this.bindExternalResource(resource);
            resource.getInfoMap().put(BOOTSTRAPPER_KEY, bootstrapper);
            this.externalResourceMap.put(resource.getName(), resource);
        }
    }

    public void modifyExternalResource(String name, HierarchicalPropertyType modifiedProperty) throws InvalidPropertyException {
        ExternalResourceType resource = this.externalResourceMap.get(name);
        ResourceBootstrapper bootstrapper = (ResourceBootstrapper)resource.getInfoMap().get(BOOTSTRAPPER_KEY);
        HashMap propertyMap = new HashMap();
        this.addProperties(modifiedProperty, propertyMap, "");
        bootstrapper.modifyProperties(propertyMap);
        try {
            InitialContext ctx = this.makeResourceContext();
            bootstrapper.reconfigResources(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ExternalResourceType getExternalResource(String name) {
        return this.externalResourceMap.get(name);
    }

    private ResourceBootstrapper bindExternalResource(ExternalResourceType resource) {
        String name = resource.getClassName();
        try {
            Class<?> resourceClass = this.getClass().getClassLoader().loadClass(name);
            ResourceBootstrapper bootstrapper = (ResourceBootstrapper)resourceClass.newInstance();
            HashMap propertyMap = new HashMap();
            this.addProperties((HierarchicalPropertyType)resource, propertyMap, "");
            bootstrapper.setProperties(propertyMap);
            InitialContext ctx = this.makeResourceContext();
            bootstrapper.initResources(ctx);
            return bootstrapper;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class " + name + " cannot be loaded for the external resource", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InitialContext makeResourceContext() throws NamingException {
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("jeus.jndi.jns.replicatebindings", "false");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        InitialContext ctx = new InitialContext(envs);
        return ctx;
    }

    private void addProperties(HierarchicalPropertyType resource, Map propertyMap, String prefix) {
        prefix = prefix + (resource.isSetNamePrefix() ? resource.getNamePrefix() + "." : "");
        List propertyList = resource.getProperty();
        for (PropertyType propertyType : propertyList) {
            propertyMap.put(prefix + propertyType.getKey(), propertyType.getValue());
        }
        for (HierarchicalPropertyType hierarchicalPropertyType : resource.getPropertyGroup()) {
            this.addProperties(hierarchicalPropertyType, propertyMap, prefix);
        }
    }

    public void destroyResources() throws JeusServerException {
        try {
            InitialContext ctx = this.makeResourceContext();
            for (ExternalResourceType resource : this.externalResourceMap.values()) {
                ResourceBootstrapper bootstrapper = (ResourceBootstrapper)resource.getInfoMap().get(BOOTSTRAPPER_KEY);
                try {
                    bootstrapper.destroyResources(ctx);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new JeusServerException(e.toString());
        }
    }
}

