/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.server.service.JEUSService;
import jeus.server.service.NodeListServiceMBean;
import jeus.util.JeusException;

public class NodeListService
extends JEUSService
implements NodeListServiceMBean,
NotificationListener {
    private static Set nodeList = new HashSet();
    private JEUSManagerMBean jeusManager;
    private boolean isBackupNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeListService(ObjectName jeusManagerObjectName) throws IOException {
        MBeanServerConnection msFacade = NodeListService.getMEJBUtility();
        this.jeusManager = JMXUtility.getProxy(msFacade, jeusManagerObjectName, JEUSManagerMBean.class, true);
        this.isBackupNode = this.jeusManager.isBackupNode();
        this.jeusManager.addNotificationListener(this, new NodeListNotificationFilter(), null);
        String[] names = this.jeusManager.getAliveNodeNames();
        Set set = nodeList;
        synchronized (set) {
            for (int i = 0; i < names.length; ++i) {
                nodeList.add(names[i]);
            }
        }
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException, IOException {
        NodeListService srvmbean = target instanceof ObjectName ? new NodeListService((ObjectName)target) : new NodeListService(parent);
        return srvmbean.createMBean(srvName, "JeusService", parent, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNodeName(Notification notification) {
        Set set = nodeList;
        synchronized (set) {
            nodeList.remove(notification.getUserData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeName(Notification notification) {
        Set set = nodeList;
        synchronized (set) {
            nodeList.add(notification.getUserData());
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("jeus.manger.cluster.resurrected")) {
            this.addNodeName(notification);
            this.sendNotification(JEUSMANAGER_CLUSTER_RESURRECTED, notification.getMessage(), (Serializable)notification.getUserData());
        } else if (notification.getType().equals("jeus.manger.cluster.failed")) {
            this.removeNodeName(notification);
            this.sendNotification(JEUSMANAGER_CLUSTER_FAILED, notification.getMessage(), (Serializable)notification.getUserData());
        } else if (notification.getType().equals("jeus.manger.cluster.downed")) {
            this.removeNodeName(notification);
            this.sendNotification(JEUSMANAGER_CLUSTER_DOWNED, notification.getMessage(), (Serializable)notification.getUserData());
        } else if (notification.getType().equals("jeus.manger.cluster.backup.resurrected")) {
            this.sendNotification(JEUSMANAGER_BACKUP_CLUSTER_RESURRECTED, notification.getMessage(), (Serializable)notification.getUserData());
        } else if (notification.getType().equals("jeus.manger.cluster.backup.failed")) {
            this.sendNotification(JEUSMANAGER_BACKUP_CLUSTER_FAILED, notification.getMessage(), (Serializable)notification.getUserData());
        }
    }

    public String[] getEventTypes() {
        return eventType;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return eventNotificationInfo;
    }

    public String getJeusType() {
        return "NodeListService";
    }

    public void startService(Object obj) throws JeusException {
    }

    public void stopService() throws JeusException {
    }

    protected void preDestruction() {
        try {
            this.jeusManager.removeNotificationListener(this);
        }
        catch (ListenerNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliveNodeNames() {
        Set set = nodeList;
        synchronized (set) {
            return nodeList.toArray(new String[nodeList.size()]);
        }
    }

    public boolean isInWorkingCluster(String nodeName) {
        JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
        for (int i = 0; i < desc.primarys.size(); ++i) {
            String clusteredNode = (String)desc.primarys.get(i);
            if (!nodeName.equals(clusteredNode)) continue;
            return nodeList.contains(nodeName);
        }
        return true;
    }

    public boolean isBackupNode() {
        return this.isBackupNode;
    }

    static class NodeListNotificationFilter
    implements NotificationFilter {
        NodeListNotificationFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            return notification.getType().equals("jeus.manger.cluster.downed") || notification.getType().equals("jeus.manger.cluster.failed") || notification.getType().equals("jeus.manger.cluster.backup.failed") || notification.getType().equals("jeus.manger.cluster.backup.resurrected") || notification.getType().equals("jeus.manger.cluster.resurrected");
        }
    }
}

