/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.descriptor.bind.SessionServerDescriptorJB;
import jeus.descriptor.jeusserver.SessionServerDescriptor;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.JeusServerException;
import jeus.server.service.JEUSService;
import jeus.server.service.SessionServerServiceMBean;
import jeus.server.service.SessionServerStatsImpl;
import jeus.sessionmanager.central.CentralSessionServer;
import jeus.util.ErrorMsgManager;
import jeus.util.LicenseException;
import jeus.util.Runner;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Session0;
import jeus.util.properties.JeusNetPropertyValues;

public class SessionServerService
extends JEUSService
implements SessionServerServiceMBean {
    private static boolean isSessionServerStarted = false;
    private CentralSessionServer sessionsvr;
    private boolean started = false;
    private ResourcePermission sessionServerPermission;
    private SessionServerStatsImpl ssStats = new SessionServerStatsImpl();

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SessionServerService mo = new SessionServerService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "SessionServerService");
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean parent = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return parent.getPermissionName() + ".sessionsvr." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.sessionServerPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"sessionServer");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionServerPermission);
        try {
            SessionServerDescriptor ssDesc = null;
            SessionServerDescriptor primary = SessionServerDescriptorJB.getPrimarySessionServerDesc();
            SessionServerDescriptor backup = SessionServerDescriptorJB.getBackupSessionServerDesc();
            if (primary != null && primary.getServerName().equals(VirtualDNS.LOCAL_VIRTUALNAME)) {
                ssDesc = primary;
            } else if (backup != null && backup.getServerName().equals(VirtualDNS.LOCAL_VIRTUALNAME)) {
                ssDesc = backup;
            }
            if (ssDesc != null && !isSessionServerStarted) {
                int edition = Runner.getLicenseEdition();
                if (edition != Runner.LIC_EDITION_BASEPLUS && edition != Runner.LIC_EDITION_ENTERPRISE) {
                    throw new LicenseException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Session0._1333));
                }
                this.sessionsvr = new CentralSessionServer(ssDesc);
                this.sessionsvr.export(JeusNetPropertyValues.LOCAL_HOSTNAME, this);
                isSessionServerStarted = true;
                this.started = true;
                if (logger.isLoggable(JeusMessage_Manager._188_LEVEL)) {
                    logger.log(JeusMessage_Manager._188_LEVEL, JeusMessage_Manager._188);
                }
            }
        }
        catch (Throwable e) {
            this.stopService();
            if (e instanceof LicenseException) {
                throw (LicenseException)e;
            }
            throw new JeusServerException(JeusMessage_Manager._189, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionServerPermission);
        try {
            if (this.sessionsvr != null && this.started) {
                this.sessionsvr.unexport();
                this.sessionsvr = null;
            }
        }
        catch (Throwable ex1) {
            if (logger.isLoggable(JeusMessage_Manager._190_LEVEL)) {
                logger.log(JeusMessage_Manager._190_LEVEL, JeusMessage_Manager._190, ex1);
            }
        }
        finally {
            isSessionServerStarted = false;
            this.started = false;
            this.destroyMBean();
        }
    }

    public Stats getstats() {
        LoginUtil.checkPermissionWithRuntimeException(this.getstatsPermission);
        if (this.sessionsvr != null) {
            return this.sessionsvr.updateStats(this.ssStats);
        }
        return null;
    }

    public List getHandlerNames() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.sessionServerPermission);
        if (this.sessionsvr == null) {
            return new ArrayList();
        }
        return this.sessionsvr.getHandlerNames();
    }

    public String getJeusType() {
        return "SessionServerService";
    }
}

