/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import java.security.Permission;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEManagedObjectMBean;
import jeus.management.j2ee.J2EEManagedObjectSupport;
import jeus.management.snmp.agent.SnmpAgent;
import jeus.security.resource.ResourcePermission;
import jeus.security.util.LoginUtil;
import jeus.security.util.PermissionMaker;
import jeus.server.service.SnmpAgentServiceMBean;

public class SnmpAgentService
extends J2EEManagedObjectSupport
implements SnmpAgentServiceMBean {
    private String exportName;
    private SnmpAgent target;
    private ResourcePermission smnpAgentPermission;

    public SnmpAgentService(String srvName, SnmpAgent target) {
        this.exportName = srvName;
        this.target = target;
    }

    public SnmpAgentService(SnmpAgent target) {
        this.target = target;
    }

    protected String initPermissionName() {
        J2EEManagedObjectMBean module = JMXUtility.getProxy((MBeanServerConnection)this.mbs, this.parentObjectName, J2EEManagedObjectMBean.class, false);
        return module.getPermissionName() + ".service." + "SnmpAgentService";
    }

    protected void makePermissions() {
        super.makePermissions();
        this.smnpAgentPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"smnpAgent");
    }

    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object agent) throws InstanceAlreadyExistsException {
        SnmpAgentService mo = new SnmpAgentService(srvName, (SnmpAgent)agent);
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "SnmpAgentService");
    }

    public long getSnmpVersion() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        return this.target.getSnmpVersion();
    }

    public boolean isSecurityEnabled() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        return this.target.isSecurityEnabled();
    }

    public int getMaxPacketSize() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        return this.target.getMaxPacketSize();
    }

    public Vector getTrapDemonIpAddress() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        return this.target.getTrapDemonIpAddress();
    }

    public Vector getTrapDemonPorts() {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        return this.target.getTrapDemonPorts();
    }

    public void setSnmpVersion(long snmpVersion) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        this.target.setSnmpVersion(snmpVersion);
    }

    public void setMaxPacketSize(int maxPacketSize) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        this.target.setMaxPacketSize(maxPacketSize);
    }

    public void setSecurityEnable(boolean securityEnable) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        this.target.setSecurityEnable(securityEnable);
    }

    public void setTrapDemonIpAddresses(Vector tdIpAddresses) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        this.target.setTrapDemonIpAddresses(tdIpAddresses);
    }

    public void setTrapDemonPorts(Vector tdPorts) {
        LoginUtil.checkPermissionWithRuntimeException((Permission)this.smnpAgentPermission);
        this.target.setTrapDemonPorts(tdPorts);
    }
}

