/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.service;

import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.jeusserver.JeusMainDescriptor;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.security.spi.LoginService;
import jeus.server.JeusServerException;
import jeus.server.SystemEngineController;
import jeus.server.service.JEUSService;
import jeus.server.service.SystemEngineServiceMBean;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Manager;

public class SystemEngineService
extends JEUSService
implements SystemEngineServiceMBean {
    public static J2EEManagedObject createMBean(String srvName, ObjectName parent, Object target) throws InstanceAlreadyExistsException {
        SystemEngineService mo = new SystemEngineService();
        return mo.createMBean(srvName, "JeusService", parent, parentKeyMap, "SystemEngineService");
    }

    public void startService(Object obj) throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            JeusMainDescriptor desc = JeusMainDescriptorJB.getLocalJeusMainDescriptor();
            if (desc.isEnableWA()) {
                SystemEngineController.startEngine(VirtualDNS.LOCAL_VIRTUALNAME, desc.isEnableWA(), desc.getAllowedServer());
                if (logger.isLoggable(JeusMessage_Manager._191_LEVEL)) {
                    logger.log(JeusMessage_Manager._191_LEVEL, JeusMessage_Manager._191);
                }
            }
        }
        catch (JeusServerException e) {
            this.stopService();
            throw new JeusServerException(JeusMessage_Manager._192, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws JeusServerException {
        LoginService.checkCodeSubject();
        try {
            SystemEngineController.downEngine();
        }
        catch (Throwable ex1) {
            if (logger.isLoggable(JeusMessage_Manager._193_LEVEL)) {
                logger.log(JeusMessage_Manager._193_LEVEL, JeusMessage_Manager._193, ex1);
            }
        }
        finally {
            this.destroyMBean();
        }
    }

    public String getJeusType() {
        return "SystemEngineService";
    }
}

