/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.management.JMXUtility;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.server.service.JeusLogServiceMBean;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.servlet.deployment.descriptor.bind.ContextDescriptorJB;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WebContainerType;
import jeus.xml.binding.util.JAXBContextFactory;
import jeus.xml.binding.util.JeusBinding;
import jeus.xml.util.IXPathAPI;
import jeus.xml.util.XMLSurgeon;
import jeus.xml.util.XPathAPIFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConfigPrinter {
    private WebContainerType config;
    private JeusLogger logger;
    private String nodeName;
    private String containerName;
    private WebEngineMoMBean mbean;
    private static final String OPTION_ALL = "all";
    private static final String OPTION_CG = "cg";
    private static final String OPTION_VH = "vh";
    private static final String OPTION_C = "c";
    private static final String OPTION_CTX = "ctx";
    private static final String OPTION_CN = "cn";
    private static final String OPTION_JSP = "jsp";
    private static final String OPTION_DB = "db";
    private static final String OPTION_LOG = "log";
    private static final String OPTION_SC = "sc";
    private static final String OPTION_RH = "rh";
    private static DocumentBuilder builder;
    private static HashMap xpathTemplate;

    public ConfigPrinter(String nodeName, String containerName, JeusLogger logger, WebEngineMoMBean mbean) throws Exception {
        this.logger = logger;
        this.nodeName = nodeName;
        this.containerName = containerName;
        this.mbean = mbean;
        this.config = mbean.getConfiguration();
    }

    public void executeConfig(Hashtable params) throws Exception {
        this.executeConfigCommandSub(this.config, " ", params);
    }

    private void traverse(Node node, String indent, int depth) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            buf.append(indent);
        }
        buf.append(node.getNodeName());
        Node textnode = node.getFirstChild();
        if (textnode != null && textnode.getNodeType() == 3 && textnode.getNodeValue() != null && textnode.getNodeValue().trim().length() > 0) {
            buf.append("=[" + node.getFirstChild().getNodeValue() + "]");
        }
        this.logger.directLog(buf.toString());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.traverse(children.item(i), indent + " ", depth + 1);
        }
    }

    private void executeConfigCommandSub(Object obj, String indent, Hashtable params) throws Exception {
        IXPathAPI xpathAPI = XPathAPIFactory.createXPathAPI();
        Enumeration enum1 = params.keys();
        String cg = (String)params.get(OPTION_CG);
        if (cg == null) {
            cg = "";
        }
        while (enum1.hasMoreElements()) {
            String option = (String)enum1.nextElement();
            String value = (String)params.get(option);
            Document[] doc = this.getDocument(obj, option, cg, value);
            for (int i = 0; i < doc.length; ++i) {
                MessageFormat format;
                if (option.equals(OPTION_C)) {
                    option = OPTION_CTX;
                }
                if ((format = (MessageFormat)xpathTemplate.get(option)) == null) continue;
                Object[] args = null;
                args = option.equals(OPTION_VH) || option.equals(OPTION_C) || option.equals(OPTION_CN) ? new Object[]{cg, value} : new Object[]{value};
                String xpath = format.format(args);
                xpath = xpath.replaceAll("\\[[^=]+=''\\]", "");
                NodeList nodeList = xpathAPI.selectNodeList(doc[i], xpath);
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node = nodeList.item(j);
                    this.traverse(node, indent, 0);
                }
            }
        }
    }

    private Document[] getDocument(Object obj, String option, String ctxgrp, String value) throws Exception {
        JAXBContext jc = null;
        Document[] docs = new Document[1];
        Object jaxbObj = obj;
        if (option.equals(OPTION_C)) {
            String groupName = ctxgrp;
            String ctxName = value;
            WebContainerDescriptor desc = this.mbean.getConfigInfo();
            if (desc != null) {
                ContextGroupDescriptor grpDesc = desc.getContextGroupDescriptor(groupName);
                if (grpDesc != null) {
                    Document doc;
                    docs[0] = doc = this.getContextDescDoc(grpDesc, ctxName);
                } else {
                    Vector groups = desc.getContextGroupNames();
                    int len = groups.size();
                    if (len < 1) {
                        len = 1;
                    }
                    docs = new Document[len];
                    Enumeration enum1 = groups.elements();
                    int i = 0;
                    while (enum1.hasMoreElements()) {
                        Document doc;
                        groupName = (String)enum1.nextElement();
                        grpDesc = desc.getContextGroupDescriptor(groupName);
                        docs[i] = doc = this.getContextDescDoc(grpDesc, ctxName);
                        ++i;
                    }
                }
            }
        } else if (option.equals(OPTION_LOG)) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
            env.put("java.naming.provider.url", this.nodeName);
            MEJBUtility utility = MEJBUtility.getMEJBUtility(env);
            ObjectName logServiceName = JMXUtility.queryLogService((MBeanServerConnection)utility, this.nodeName, this.containerName);
            JeusLogServiceMBean logService = JMXUtility.getProxy((MBeanServerConnection)utility, logServiceName, JeusLogServiceMBean.class, false);
            jaxbObj = logService.getSystemLogging("jeus.servlet");
            HashMap bindingMap = new HashMap();
            Document jaxbdoc = JeusBinding.createDocument((JeusBinding)((JeusBinding)jaxbObj), bindingMap);
            docs[0] = builder.newDocument();
            NodeList list = jaxbdoc.getDocumentElement().getChildNodes();
            Element root = docs[0].createElement("system-logging");
            docs[0].appendChild(root);
            for (int j = 0; j < list.getLength(); ++j) {
                root.appendChild(docs[0].importNode(list.item(j), true));
            }
        } else {
            jc = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Marshaller m = jc.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectFactory fac = new ObjectFactory();
            XMLSurgeon.leave(fac.createWebContainer((WebContainerType)jaxbObj), m, os);
            docs[0] = builder.parse(new ByteArrayInputStream(os.toByteArray()));
        }
        return docs;
    }

    private Document getContextDescDoc(ContextGroupDescriptor grpDesc, String ctxName) throws Exception {
        ContextDescriptor ctxDesc = grpDesc.getContextDescriptorByName(ctxName);
        ContextType jeusWebDD = ((ContextDescriptorJB)ctxDesc).getElement();
        if (ctxDesc != null) {
            JAXBContext jc = JAXBContextFactory.getContext("jeus.xml.binding.jeusDD");
            Marshaller m = jc.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectFactory fac = new ObjectFactory();
            XMLSurgeon.leave(fac.createJeusWebDd(jeusWebDD), m, os);
            return builder.parse(new ByteArrayInputStream(os.toByteArray()));
        }
        return null;
    }

    private String getTagNameFromMethodName(String org) {
        if (org.startsWith("is")) {
            org = org.substring(2);
        } else if (org.startsWith("get")) {
            org = org.substring(3);
        } else {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = org.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(org.charAt(i))) {
                result.append('-');
                result.append(Character.toLowerCase(org.charAt(i)));
                continue;
            }
            result.append(org.charAt(i));
        }
        return result.toString();
    }

    private void printValue(Object rval, String indent, String tagName) throws Exception {
        this.logger.directLog(indent + tagName + "=[" + String.valueOf(rval) + "]");
    }

    static {
        xpathTemplate = new HashMap();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            xpathTemplate.put(OPTION_ALL, new MessageFormat("/"));
            xpathTemplate.put(OPTION_CG, new MessageFormat("/web-container/context-group[group-name=''{0}'']"));
            xpathTemplate.put(OPTION_VH, new MessageFormat("/web-container/context-group[group-name=''{0}'']/virtual-host[virtual-host-name=''{1}'']"));
            xpathTemplate.put(OPTION_C, new MessageFormat("/web-container/context-group[group-name=''{0}'']/context[context-name=''{1}'']"));
            xpathTemplate.put(OPTION_CTX, new MessageFormat("/jeus-web-dd/context"));
            xpathTemplate.put(OPTION_CN, new MessageFormat("/web-container/context-group[group-name=''{0}'']/webserver-connection/*[listener-id=''{1}'']"));
            xpathTemplate.put(OPTION_JSP, new MessageFormat("/web-container/context-group[group-name=''{0}'']/jsp-engine"));
            xpathTemplate.put(OPTION_DB, new MessageFormat("/web-container/db-connection-pool[pool-name=''{0}'']"));
            xpathTemplate.put(OPTION_LOG, new MessageFormat("/system-logging"));
            xpathTemplate.put(OPTION_SC, new MessageFormat("/web-container/session-cluster"));
            xpathTemplate.put(OPTION_RH, new MessageFormat("/web-container/context-group/response-header"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

