/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.async;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jeus.io.impl.StreamHandlerImpl;
import jeus.servlet.async.AbstractAsyncServlet;
import jeus.servlet.async.RequestResponseKey;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.servlet.engine.ServletWrapper;
import jeus.servlet.loader.WebAppContextSwitch;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class AbstractTcpAsyncServlet
extends AbstractAsyncServlet {
    public abstract boolean doRequest(RequestResponseKey var1) throws IOException, ServletException;

    public abstract void doResponse(RequestResponseKey var1, Object var2) throws IOException, ServletException;

    protected abstract void doTimeout(RequestResponseKey var1) throws IOException, ServletException;

    protected void sendErrorAsync(Throwable t, String msg, RequestResponseKey rrk) {
        this.sendErrorAsync(t, msg, rrk.getRequest(), rrk.getResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendErrorAsync(Throwable t, String msg, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (logger.isLoggable(JeusMessage_WebContainer10._10101_LEVEL)) {
            if (t != null) {
                logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg, t);
            } else {
                logger.log(JeusMessage_WebContainer10._10101_LEVEL, JeusMessage_WebContainer10._10101, (Object)msg);
            }
        }
        HttpServletRequestImpl request = (HttpServletRequestImpl)servletRequest;
        HttpServletResponseImpl response = (HttpServletResponseImpl)servletResponse;
        StreamHandlerImpl streamHandler = ((NIOWebServerOutputStream)response.getOutputStream()).getStreamHandler();
        ServletWrapper executionWrapper = (ServletWrapper)request.getExecutionWrapper();
        String servletName = executionWrapper.getServletName();
        WebAppContextSwitch.preContextSwitch(executionWrapper.getReloader());
        try {
            Object copy = null;
            try {
                this.sendError(t, msg, servletRequest, servletResponse);
            }
            catch (Throwable t2) {
                String msg2 = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10115, (Object)servletName);
                logger.log(JeusMessage_WebContainer10._10115_LEVEL, msg2, t2);
                AbstractTcpAsyncServlet.finishConnection(streamHandler, "connection closed by unexpected exception while sending error in AbstractTcpAsyncServlet", t2);
            }
        }
        finally {
            WebAppContextSwitch.postContextSwitch();
        }
    }

    public void sendError(Throwable throwable, String msg, ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletResponseImpl responseImpl = (HttpServletResponseImpl)servletResponse;
        NIOWebServerOutputStream os = (NIOWebServerOutputStream)responseImpl.getOutputStream();
        StreamHandlerImpl streamHandler = null;
        if (os != null) {
            streamHandler = os.getStreamHandler();
        }
        if (streamHandler != null) {
            logger.log(JeusMessage_WebContainer10._10123_LEVEL, JeusMessage_WebContainer10._10123, new Object[]{streamHandler, msg}, throwable);
            AbstractAsyncServlet.finishConnection(streamHandler, "connection closed after sending error in AbstractTcpAsyncServlet", null);
        } else {
            logger.log(JeusMessage_WebContainer10._10124_LEVEL, JeusMessage_WebContainer10._10124, new Object[]{servletRequest}, throwable);
        }
    }
}

