/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.base;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import jeus.servlet.cache.base.CacheConfig;
import jeus.servlet.cache.base.CacheEntry;
import jeus.servlet.cache.base.EntryRefreshPolicy;
import jeus.servlet.cache.base.EntryUpdateState;
import jeus.servlet.cache.base.NeedsRefreshException;
import jeus.servlet.cache.base.algorithm.AbstractConcurrentReadCache;
import jeus.servlet.cache.base.algorithm.LRUCache;
import jeus.servlet.cache.base.events.CacheEntryEvent;
import jeus.servlet.cache.base.events.CacheEntryEventListener;
import jeus.servlet.cache.base.events.CacheEntryEventType;
import jeus.servlet.cache.base.events.CacheEventListener;
import jeus.servlet.cache.base.events.CacheGroupEvent;
import jeus.servlet.cache.base.events.CacheMapAccessEvent;
import jeus.servlet.cache.base.events.CacheMapAccessEventListener;
import jeus.servlet.cache.base.events.CacheMapAccessEventType;
import jeus.servlet.cache.base.events.CachePatternEvent;
import jeus.servlet.cache.base.events.CachewideEvent;
import jeus.servlet.cache.base.events.CachewideEventType;
import jeus.servlet.cache.base.persistence.PersistenceListener;
import jeus.servlet.cache.util.FastCronParser;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer11;

public class Cache
implements Serializable {
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.cache");
    public static final String NESTED_EVENT = "NESTED";
    protected EventListenerList listenerList = new EventListenerList();
    private AbstractConcurrentReadCache cacheMap = null;
    private Date flushDateTime = null;
    private Map updateStates = new HashMap();
    private transient ReferenceQueue refQueue = new ReferenceQueue();
    private HashMap refMap = new HashMap();
    protected CacheConfig cacheConfig;
    final String algorithmClass = "jeus.servlet.cache.base.algorithm.LRUCache";

    public Cache(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        int capacity = cacheConfig.getCapacity();
        this.cacheMap = new LRUCache(capacity);
        this.setBlocking(cacheConfig.isBlocking());
        this.cacheMap.setDecreaseFactor(cacheConfig.getDecreaseFactor());
    }

    public boolean isFlushed(CacheEntry cacheEntry) {
        if (this.flushDateTime != null) {
            long lastUpdate = cacheEntry.getLastUpdate();
            return this.flushDateTime.getTime() >= lastUpdate;
        }
        return false;
    }

    public Object getFromCache(String key) throws NeedsRefreshException {
        return this.getFromCache(key, -1, null);
    }

    public Object getFromCache(String key, int refreshPeriod) throws NeedsRefreshException {
        return this.getFromCache(key, refreshPeriod, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromCache(String key, int refreshPeriod, String cronExpiry) throws NeedsRefreshException {
        CacheEntry cacheEntry = this.getCacheEntry(key);
        if (cacheEntry == null) {
            if (this.refQueue == null) {
                this.refQueue = new ReferenceQueue();
            }
            cacheEntry = new CacheEntry(key, null, this.refQueue);
        }
        Object content = cacheEntry.getContent();
        CacheMapAccessEventType accessEventType = CacheMapAccessEventType.HIT;
        boolean reload = false;
        if (this.isStale(cacheEntry, refreshPeriod, cronExpiry)) {
            EntryUpdateState updateState = this.getUpdateState(key);
            try {
                EntryUpdateState entryUpdateState = updateState;
                synchronized (entryUpdateState) {
                    if (updateState.isAwaitingUpdate() || updateState.isCancelled()) {
                        updateState.startUpdate();
                        accessEventType = cacheEntry.isNew() ? CacheMapAccessEventType.MISS : CacheMapAccessEventType.STALE_HIT;
                    } else if (updateState.isUpdating()) {
                        if (cacheEntry.isNew() || this.isBlocking()) {
                            do {
                                try {
                                    updateState.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            } while (updateState.isUpdating());
                            if (updateState.isCancelled()) {
                                updateState.startUpdate();
                                accessEventType = cacheEntry.isNew() ? CacheMapAccessEventType.MISS : CacheMapAccessEventType.STALE_HIT;
                            } else if (updateState.isComplete()) {
                                reload = true;
                            } else if (logger.isLoggable(JeusMessage_WebContainer11._11012_LEVEL)) {
                                logger.log(JeusMessage_WebContainer11._11012_LEVEL, JeusMessage_WebContainer11._11012, (Object)key);
                            }
                        }
                    } else {
                        reload = true;
                    }
                }
            }
            finally {
                this.releaseUpdateState(updateState, key);
            }
        }
        if (reload) {
            cacheEntry = (CacheEntry)this.cacheMap.get(key);
            if (cacheEntry != null) {
                content = cacheEntry.getContent();
            } else if (logger.isLoggable(JeusMessage_WebContainer11._11013_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11013_LEVEL, JeusMessage_WebContainer11._11013, (Object)key);
            }
        }
        this.dispatchCacheMapAccessEvent(accessEventType, cacheEntry, null);
        if (accessEventType != CacheMapAccessEventType.HIT) {
            throw new NeedsRefreshException(content);
        }
        return content;
    }

    public void setPersistenceListener(PersistenceListener listener) {
        this.cacheMap.setPersistenceListener(listener);
    }

    public PersistenceListener getPersistenceListener() {
        return this.cacheMap.getPersistenceListener();
    }

    public void addCacheEventListener(CacheEventListener listener, Class clazz) {
        if (CacheEventListener.class.isAssignableFrom(clazz)) {
            this.listenerList.add(clazz, listener);
        } else if (logger.isLoggable(JeusMessage_WebContainer11._11014_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11014_LEVEL, JeusMessage_WebContainer11._11014, (Object)clazz.getName());
        }
    }

    public EventListenerList getCacheEventListenerList() {
        return this.listenerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelUpdate(String key) {
        if (key != null) {
            Map map = this.updateStates;
            synchronized (map) {
                EntryUpdateState state = (EntryUpdateState)this.updateStates.get(key);
                if (state != null) {
                    EntryUpdateState entryUpdateState = state;
                    synchronized (entryUpdateState) {
                        int usageCounter = state.cancelUpdate();
                        state.notify();
                        this.checkEntryStateUpdateUsage(key, state, usageCounter);
                    }
                } else if (logger.isLoggable(JeusMessage_WebContainer11._11015_LEVEL)) {
                    logger.log(JeusMessage_WebContainer11._11015_LEVEL, JeusMessage_WebContainer11._11015, (Object)key);
                }
            }
        }
    }

    private void checkEntryStateUpdateUsage(String key, EntryUpdateState state, int usageCounter) {
        EntryUpdateState removedState;
        if (usageCounter == 0 && state != (removedState = (EntryUpdateState)this.updateStates.remove(key)) && logger.isLoggable(JeusMessage_WebContainer11._11016_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11016_LEVEL, JeusMessage_WebContainer11._11016, new Object[]{removedState, key, state});
        }
    }

    public void flushAll() {
        Set keySet = this.cacheMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            this.flushEntry((String)iter.next());
        }
    }

    public void flushAll(Date date) {
        this.flushAll(date, null);
    }

    public void flushAll(Date date, String origin) {
        this.flushDateTime = date;
        if (this.listenerList.getListenerCount() > 0) {
            this.dispatchCachewideEvent(CachewideEventType.CACHE_FLUSHED, date, origin);
        }
    }

    public void flushEntry(String key) {
        this.flushEntry(key, null);
    }

    public void flushEntry(String key, String origin) {
        CacheEntry entry = this.getCacheEntry(key);
        if (entry != null) {
            this.flushEntry(entry, origin);
        }
    }

    public void flushGroup(String group) {
        this.flushGroup(group, null);
    }

    public void flushGroup(String group, String origin) {
        Set groupEntries = this.cacheMap.getGroup(group);
        if (groupEntries != null) {
            for (String key : groupEntries) {
                CacheEntry entry = (CacheEntry)this.cacheMap.get(key);
                if (entry == null || entry.needsRefresh(-1)) continue;
                this.flushEntry(entry, NESTED_EVENT);
            }
        }
        if (this.listenerList.getListenerCount() > 0) {
            this.dispatchCacheGroupEvent(CacheEntryEventType.GROUP_FLUSHED, group, origin);
        }
    }

    public void flushPattern(String pattern) {
        this.flushPattern(pattern, null);
    }

    public void flushPattern(String pattern, String origin) {
        if (pattern != null && pattern.length() > 0) {
            String key2 = null;
            CacheEntry entry = null;
            for (String key2 : this.cacheMap.keySet()) {
                if (key2.indexOf(pattern) < 0 || (entry = (CacheEntry)this.cacheMap.get(key2)) == null) continue;
                this.flushEntry(entry, origin);
            }
            if (this.listenerList.getListenerCount() > 0) {
                this.dispatchCachePatternEvent(CacheEntryEventType.PATTERN_FLUSHED, pattern, origin);
            }
        }
    }

    public void putInCache(String key, Object content) {
        this.putInCache(key, content, null, null, null);
    }

    public void putInCache(String key, Object content, EntryRefreshPolicy policy) {
        this.putInCache(key, content, null, policy, null);
    }

    public void putInCache(String key, Object content, String[] groups) {
        this.putInCache(key, content, groups, null, null);
    }

    public void putInCache(String key, Object content, String[] groups, EntryRefreshPolicy policy, String origin) {
        this.clearCollectedReferent();
        CacheEntry cacheEntry = this.getCacheEntry(key);
        if (cacheEntry == null) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11017_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11017_LEVEL, JeusMessage_WebContainer11._11017, (Object)key);
            }
        } else {
            cacheEntry = null;
        }
        if (this.refQueue == null) {
            this.refQueue = new ReferenceQueue();
        }
        CacheEntry newCacheEntry = new CacheEntry(key, content, this.refQueue, policy);
        this.cacheMap.put(key, newCacheEntry);
        this.refMap.put(newCacheEntry, key);
        this.completeUpdate(key);
    }

    private void clearCollectedReferent() {
        Reference ref;
        if (this.refQueue == null) {
            return;
        }
        while ((ref = this.refQueue.poll()) != null) {
            String key = (String)this.refMap.get(ref);
            if (key != null) {
                this.cacheMap.remove(key);
            }
            this.refMap.remove(ref);
        }
    }

    public void removeCacheEventListener(CacheEventListener listener, Class clazz) {
        this.listenerList.remove(clazz, listener);
    }

    protected CacheEntry getCacheEntry(String key) {
        this.clearCollectedReferent();
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("getCacheEntry called with an empty or null key");
        }
        return (CacheEntry)this.cacheMap.get(key);
    }

    protected boolean isStale(CacheEntry cacheEntry, int refreshPeriod, String cronExpiry) {
        boolean result;
        boolean bl = result = cacheEntry.needsRefresh(refreshPeriod) || this.isFlushed(cacheEntry);
        if (!result && cronExpiry != null && cronExpiry.length() > 0) {
            try {
                FastCronParser parser = new FastCronParser(cronExpiry);
                result = result || parser.hasMoreRecentMatch(cacheEntry.getLastUpdate());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryUpdateState getUpdateState(String key) {
        EntryUpdateState updateState;
        Map map = this.updateStates;
        synchronized (map) {
            updateState = (EntryUpdateState)this.updateStates.get(key);
            if (updateState == null) {
                updateState = new EntryUpdateState();
                this.updateStates.put(key, updateState);
            } else {
                updateState.incrementUsageCounter();
            }
        }
        return updateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseUpdateState(EntryUpdateState state, String key) {
        Map map = this.updateStates;
        synchronized (map) {
            int usageCounter = state.decrementUsageCounter();
            this.checkEntryStateUpdateUsage(key, state, usageCounter);
        }
    }

    protected void clear() {
        this.cacheMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeUpdate(String key) {
        Map map = this.updateStates;
        synchronized (map) {
            EntryUpdateState state = (EntryUpdateState)this.updateStates.get(key);
            if (state != null) {
                EntryUpdateState entryUpdateState = state;
                synchronized (entryUpdateState) {
                    int usageCounter = state.completeUpdate();
                    state.notifyAll();
                    this.checkEntryStateUpdateUsage(key, state, usageCounter);
                }
            }
        }
    }

    public void removeEntry(String key) {
        this.removeEntry(key, null);
    }

    protected void removeEntry(String key, String origin) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheMap.get(key);
        this.cacheMap.remove(key);
        if (this.listenerList.getListenerCount() > 0) {
            CacheEntryEvent event = new CacheEntryEvent(this, cacheEntry, origin);
            this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_REMOVED, event);
        }
    }

    private void dispatchCacheEntryEvent(CacheEntryEventType eventType, CacheEntryEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheEntryEventListener.class) continue;
            if (eventType.equals(CacheEntryEventType.ENTRY_ADDED)) {
                ((CacheEntryEventListener)listeners[i + 1]).cacheEntryAdded(event);
                continue;
            }
            if (eventType.equals(CacheEntryEventType.ENTRY_UPDATED)) {
                ((CacheEntryEventListener)listeners[i + 1]).cacheEntryUpdated(event);
                continue;
            }
            if (eventType.equals(CacheEntryEventType.ENTRY_FLUSHED)) {
                ((CacheEntryEventListener)listeners[i + 1]).cacheEntryFlushed(event);
                continue;
            }
            if (!eventType.equals(CacheEntryEventType.ENTRY_REMOVED)) continue;
            ((CacheEntryEventListener)listeners[i + 1]).cacheEntryRemoved(event);
        }
    }

    private void dispatchCacheGroupEvent(CacheEntryEventType eventType, String group, String origin) {
        CacheGroupEvent event = new CacheGroupEvent(this, group, origin);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheEntryEventListener.class || !eventType.equals(CacheEntryEventType.GROUP_FLUSHED)) continue;
            ((CacheEntryEventListener)listeners[i + 1]).cacheGroupFlushed(event);
        }
    }

    private void dispatchCacheMapAccessEvent(CacheMapAccessEventType eventType, CacheEntry entry, String origin) {
        CacheMapAccessEvent event = new CacheMapAccessEvent(eventType, entry, origin);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheMapAccessEventListener.class) continue;
            ((CacheMapAccessEventListener)listeners[i + 1]).accessed(event);
        }
    }

    private void dispatchCachePatternEvent(CacheEntryEventType eventType, String pattern, String origin) {
        CachePatternEvent event = new CachePatternEvent(this, pattern, origin);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheEntryEventListener.class || !eventType.equals(CacheEntryEventType.PATTERN_FLUSHED)) continue;
            ((CacheEntryEventListener)listeners[i + 1]).cachePatternFlushed(event);
        }
    }

    private void dispatchCachewideEvent(CachewideEventType eventType, Date date, String origin) {
        CachewideEvent event = new CachewideEvent(this, date, origin);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheEntryEventListener.class || !eventType.equals(CachewideEventType.CACHE_FLUSHED)) continue;
            ((CacheEntryEventListener)listeners[i + 1]).cacheFlushed(event);
        }
    }

    private void flushEntry(CacheEntry entry, String origin) {
        String key = entry.getKey();
        entry.flush();
        if (!entry.isNew()) {
            this.cacheMap.put(key, entry);
        }
        if (this.listenerList.getListenerCount() > 0) {
            CacheEntryEvent event = new CacheEntryEvent(this, entry, origin);
            this.dispatchCacheEntryEvent(CacheEntryEventType.ENTRY_FLUSHED, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbUpdateState() {
        Map map = this.updateStates;
        synchronized (map) {
            return this.updateStates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbEntries() {
        AbstractConcurrentReadCache abstractConcurrentReadCache = this.cacheMap;
        synchronized (abstractConcurrentReadCache) {
            return this.cacheMap.size();
        }
    }

    public synchronized void setCapacity(int capacity) {
        this.cacheConfig.setCapacity(capacity);
        this.cacheMap.setMaxEntries(capacity);
    }

    public void setBlocking(boolean blocking) {
        this.cacheConfig.setBlocking(blocking);
    }

    public void setPersistenceClassName(String persistenceClassName) {
        this.cacheConfig.setPersistenceClassName(persistenceClassName);
    }

    public synchronized void setDecreaseFactor(float decreaseFactor) {
        this.cacheConfig.setDecreaseFactor(decreaseFactor);
        this.cacheMap.setDecreaseFactor(decreaseFactor);
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public int getCurrentSize() {
        return this.cacheMap.size();
    }

    public synchronized int getCapacity() {
        return this.cacheConfig.getCapacity();
    }

    public boolean isBlocking() {
        return this.cacheConfig.isBlocking();
    }

    public String getPersistenceClassName() {
        return this.cacheConfig.getPersistenceClassName();
    }

    public synchronized float getDecreaseFactor() {
        return this.cacheConfig.getDecreaseFactor();
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }
}

