/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.util;

import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import jeus.servlet.cache.base.CacheException;
import jeus.servlet.cache.base.KeyIterator;

public class CacheUtil {
    private static HashMap scopeMap = new HashMap();
    public static final int SECOND = 1;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    public static final int WEEK = 604800;
    public static final int MONTH = 2592000;
    public static final int YEAR = 31536000;

    public static String getScopeAsString(int scope) {
        return (String)scopeMap.get(new Integer(scope));
    }

    public static int getScopeAsInt(String scope) {
        Set set = scopeMap.keySet();
        for (Object key : set) {
            if (!scope.equals(scopeMap.get(key))) continue;
            return (Integer)key;
        }
        return -1;
    }

    public static String getKeyValueString(PageContext pageContext, String keyAttribute) throws CacheException {
        StringBuffer sb = new StringBuffer();
        String keyValue = null;
        KeyIterator iterator = new KeyIterator(keyAttribute);
        try {
            while (iterator.hasMoreKeys()) {
                String key = iterator.getNextKey();
                String scope = iterator.getKeyScope();
                if ("parameter".equals(scope)) {
                    keyValue = pageContext.getRequest().getParameter(key);
                } else if ("page".equals(scope)) {
                    keyValue = (String)pageContext.getAttribute(key);
                } else if ("request".equals(scope)) {
                    keyValue = (String)pageContext.getRequest().getAttribute(key);
                } else if ("session".equals(scope)) {
                    HttpSession httpsession = pageContext.getSession();
                    if (httpsession != null) {
                        keyValue = (String)httpsession.getAttribute(key);
                    }
                } else if ("application".equals(scope)) {
                    keyValue = (String)pageContext.getServletContext().getAttribute(key);
                } else {
                    throw new CacheException("invalide scope: " + scope);
                }
                if (keyValue != null) {
                    sb.append(key).append('.').append(keyValue).append('_');
                    continue;
                }
                throw new CacheException("value of key is null: " + scope + "." + key);
            }
        }
        catch (ClassCastException e) {
            throw new CacheException("classcast exception: keyValue is not string type:" + e.getMessage());
        }
        return sb.toString();
    }

    public static int parseTimeout(String timeout) {
        int time = 0;
        try {
            time = Integer.parseInt(timeout);
        }
        catch (Exception ex) {
            for (int i = 0; i < timeout.length(); ++i) {
                if (Character.isDigit(timeout.charAt(i))) continue;
                time = Integer.parseInt(timeout.substring(0, i));
                switch (timeout.charAt(i)) {
                    case 's': {
                        time *= 1;
                        break;
                    }
                    case 'm': {
                        time *= 60;
                        break;
                    }
                    case 'h': {
                        time *= 3600;
                        break;
                    }
                    case 'd': {
                        time *= 86400;
                        break;
                    }
                    case 'w': {
                        time *= 604800;
                        break;
                    }
                }
                break;
            }
        }
        return time;
    }

    static {
        scopeMap.put(new Integer(1), "page");
        scopeMap.put(new Integer(2), "request");
        scopeMap.put(new Integer(3), "session");
        scopeMap.put(new Integer(4), "application");
    }
}

