/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.web;

import java.io.Serializable;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import jeus.servlet.cache.base.Cache;
import jeus.servlet.cache.base.CacheEntry;
import jeus.servlet.cache.base.WebCacheConfig;
import jeus.servlet.cache.web.ServletCacheAdministrator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer11;

public final class ServletCache
extends Cache
implements HttpSessionBindingListener,
Serializable {
    private static JeusLogger logger;
    private ServletCacheAdministrator admin;

    public ServletCache(ServletCacheAdministrator admin, WebCacheConfig cacheConfig) {
        super(cacheConfig);
        this.admin = admin;
        logger = admin.getLogger();
    }

    public int getScopeAsInt() {
        return ((WebCacheConfig)this.cacheConfig).getScopeAsInt();
    }

    public String getScopeAsString() {
        return ((WebCacheConfig)this.cacheConfig).getScope();
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (logger.isLoggable(JeusMessage_WebContainer11._11019_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11019_LEVEL, JeusMessage_WebContainer11._11019, new Object[]{event.getSession(), event.getName()});
        }
        this.admin.finalizeListeners(this);
        this.clear();
    }

    protected boolean isStale(CacheEntry cacheEntry, int refreshPeriod, String cronExpiry) {
        return super.isStale(cacheEntry, refreshPeriod, cronExpiry) || this.admin.isScopeFlushed(cacheEntry, this.getScopeAsInt());
    }
}

