/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.cache.web.tag;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import jeus.servlet.cache.base.Cache;
import jeus.servlet.cache.base.CacheException;
import jeus.servlet.cache.base.NeedsRefreshException;
import jeus.servlet.cache.util.CacheUtil;
import jeus.servlet.cache.web.ServletCache;
import jeus.servlet.cache.web.ServletCacheAdministrator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer11;

public class CacheTag
extends BodyTagSupport
implements TryCatchFinally {
    private String name;
    private String key;
    private String flush;
    private int timeout;
    private String scope;
    private int size;
    private boolean async;
    private float df;
    private ServletCacheAdministrator admin;
    private int scopeAsInt;
    private Cache cache;
    private String actualKey;
    private boolean cancelUpdateRequired;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final String CACHE_TAG_COUNTER_KEY = "__jeuscache_tag_counter";
    private static final String REFERSH_KEY = "_jeuscache_refresh";
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.cache");

    public CacheTag() {
        this.initialize();
    }

    public int doStartTag() throws JspException {
        int returnCode;
        block9: {
            returnCode = 2;
            if (this.admin == null) {
                this.admin = ServletCacheAdministrator.getInstance(this.pageContext.getServletContext());
            }
            this.getCacheKey();
            if (this.flushCache()) {
                return 0;
            }
            this.retrieveCache();
            if (this.refreshCache()) {
                return 2;
            }
            try {
                String content = (String)this.cache.getFromCache(this.actualKey, this.timeout);
                try {
                    if (content != null) {
                        this.pageContext.getOut().write(content);
                        returnCode = 0;
                    }
                }
                catch (IOException e) {
                    throw new JspTagException("IO Exception: " + e.getMessage());
                }
            }
            catch (NeedsRefreshException nre) {
                this.cancelUpdateRequired = true;
                if (!logger.isLoggable(JeusMessage_WebContainer11._11051_LEVEL)) break block9;
                logger.log(JeusMessage_WebContainer11._11051_LEVEL, JeusMessage_WebContainer11._11051, (Object)this.actualKey);
            }
        }
        if (returnCode == 2 && logger.isLoggable(JeusMessage_WebContainer11._11047_LEVEL)) {
            logger.log(JeusMessage_WebContainer11._11047_LEVEL, JeusMessage_WebContainer11._11047, (Object)this.actualKey);
        }
        return returnCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean flushCache() throws JspException {
        boolean flushed = "true".equals(this.flush);
        if (!flushed) return flushed;
        if (this.name == null) throw new JspException("flush error: name must be specified");
        Object target = this.getAttribute(this.name);
        if (target != null) {
            if (!(target instanceof ServletCache)) throw new JspException("flush error: cachedEntry is not proper type: " + target.getClass());
            this.flushNamedCache(target);
            return flushed;
        } else {
            this.flushDefaultCache();
        }
        return flushed;
    }

    private void flushNamedCache(Object target) {
        if (this.key != null) {
            ((Cache)target).flushEntry(this.actualKey);
        } else {
            ((Cache)target).flushAll();
        }
    }

    private void flushDefaultCache() {
        Cache defaultCache = (Cache)this.getAttribute("_jeuscache_default_key_");
        if (defaultCache == null) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11050_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11050_LEVEL, JeusMessage_WebContainer11._11050, (Object)this.name);
            }
        } else {
            defaultCache.flushEntry(this.actualKey);
        }
    }

    private Object getAttribute(String key) {
        Object target;
        ServletContext context = this.pageContext.getServletContext();
        if (this.scopeAsInt == 3) {
            HttpSession httpSession = ((HttpServletRequest)this.pageContext.getRequest()).getSession(true);
            target = httpSession.getAttribute(key);
        } else {
            target = context.getAttribute(key);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshCache() throws JspException {
        String flag = "false";
        if ("application".equals(this.scope)) {
            ServletContext context;
            ServletContext servletContext = context = this.pageContext.getServletContext();
            synchronized (servletContext) {
                flag = (String)context.getAttribute(REFERSH_KEY);
            }
        } else if ("session".equals(this.scope)) {
            HttpSession session = this.pageContext.getSession();
            if (session != null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    flag = (String)session.getAttribute(REFERSH_KEY);
                }
            }
        } else {
            throw new JspException("invalid scope: " + this.scope);
        }
        return "true".equals(flag);
    }

    public int doAfterBody() throws JspException {
        try {
            String body = null;
            if (this.bodyContent != null && this.timeout != 0) {
                body = this.bodyContent.getString();
                if (logger.isLoggable(JeusMessage_WebContainer11._11044_LEVEL)) {
                    logger.log(JeusMessage_WebContainer11._11044_LEVEL, JeusMessage_WebContainer11._11044, (Object)this.actualKey);
                }
                this.cache.putInCache(this.actualKey, body);
                this.cancelUpdateRequired = false;
            } else {
                this.cancelUpdateRequired = true;
            }
            if (this.bodyContent == null) {
                throw new IOException("bodycontent(JspWriter) is null");
            }
            this.bodyContent.clearBody();
            this.bodyContent.write(body);
            this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspTagException {
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCacheKey() throws JspException {
        if (this.key == null) {
            if (this.name == null) {
                String suffix;
                ServletRequest servletRequest = this.pageContext.getRequest();
                synchronized (servletRequest) {
                    Object o = this.pageContext.getRequest().getAttribute(CACHE_TAG_COUNTER_KEY);
                    suffix = o == null ? "1" : Integer.toString(Integer.parseInt((String)o) + 1);
                }
                this.pageContext.getRequest().setAttribute(CACHE_TAG_COUNTER_KEY, (Object)suffix);
                this.actualKey = this.admin.generateEntryName(this.pageContext, (HttpServletRequest)this.pageContext.getRequest(), suffix);
            } else {
                this.actualKey = this.name;
            }
        } else {
            if (this.name == null) {
                throw new JspException("name must be specified with key");
            }
            try {
                this.actualKey = CacheUtil.getKeyValueString(this.pageContext, this.key);
            }
            catch (CacheException e) {
                throw new JspException(e.getMessage());
            }
        }
    }

    private void retrieveCache() throws JspException {
        if (this.key == null) {
            this.retrieveCacheFromScope(null);
        } else {
            this.retrieveCacheFromScope(this.name);
        }
    }

    private void retrieveCacheFromScope(String name) {
        ServletContext context = this.pageContext.getServletContext();
        if (this.scopeAsInt == 3) {
            HttpSession httpSession = ((HttpServletRequest)this.pageContext.getRequest()).getSession(true);
            this.cache = this.admin.getSessionScopeCache(context, name, httpSession, this.size, this.async, this.df);
        } else {
            this.cache = this.admin.getAppScopeCache(context, name, this.size, this.async, this.df);
        }
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        if (this.cancelUpdateRequired && this.actualKey != null) {
            this.cache.cancelUpdate(this.actualKey);
        }
    }

    public void release() {
        this.name = null;
        this.key = null;
        this.actualKey = null;
        super.release();
    }

    private void initialize() {
        this.name = null;
        this.key = null;
        this.flush = "false";
        this.timeout = 3600;
        this.size = Integer.MAX_VALUE;
        this.async = false;
        this.df = 0.25f;
        this.actualKey = null;
        this.setScope("application");
    }

    public String getFlush() {
        return this.flush;
    }

    public void setFlush(String flush) {
        this.flush = flush;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        try {
            this.timeout = CacheUtil.parseTimeout(timeout);
        }
        catch (Exception ex) {
            if (logger.isLoggable(JeusMessage_WebContainer11._11042_LEVEL)) {
                logger.log(JeusMessage_WebContainer11._11042_LEVEL, JeusMessage_WebContainer11._11041, new Object[]{timeout, ex.getMessage()});
            }
            this.timeout = 3600;
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
        this.scopeAsInt = CacheUtil.getScopeAsInt(scope);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = Integer.parseInt(size);
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(String async) {
        this.async = "true".equals(async);
    }

    public float getDf() {
        return this.df;
    }

    public void setDf(String df) {
        this.df = Float.parseFloat(df);
    }
}

