/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

public abstract class Monitor {
    protected long period = 0L;
    protected long nextInvokeTime = 0L;
    protected String name;

    public Monitor(String name) {
        this.name = name;
        this.period = 0L;
    }

    public void setPeriod(long value) {
        this.period = value;
        this.setNextInvokeTime(0L);
    }

    public long doMonitor(long currentTime) {
        if (this.isEnabled()) {
            if (this.nextInvokeTime <= currentTime) {
                this.doJob();
                this.setNextInvokeTime(currentTime);
                return this.nextInvokeTime;
            }
            return this.nextInvokeTime;
        }
        return -1L;
    }

    protected abstract void doJob();

    protected boolean isEnabled() {
        return this.period > 0L;
    }

    protected void setNextInvokeTime(long currentTime) {
        this.nextInvokeTime = currentTime + this.period;
    }
}

