/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.common;

import java.io.PrintStream;
import java.util.Hashtable;
import jeus.servlet.common.ContextGroupMonitor;
import jeus.servlet.common.Monitor;
import jeus.servlet.common.SessionMonitor;
import jeus.servlet.common.ThreadPoolMonitor;
import jeus.servlet.common.WebContainerManager;
import jeus.servlet.deployment.descriptor.ContainerMonitorDescriptor;
import jeus.servlet.loader.ClassLoadManager;

public class WebContainerMonitor
implements Runnable {
    private static final int MAX_MONITORS = 4;
    public static final int THREAD_POOL_MONITOR = 0;
    public static final int SESSION_MONITOR = 2;
    public static final int SERVLET_MONITOR = 3;
    public static final int LOG_MONITOR = 1;
    private long currentTime = 0L;
    private PrintStream systemOut;
    private PrintStream systemErr;
    private ContainerMonitorDescriptor desc;
    private String engineName;
    private boolean running = false;
    private boolean destroyed = false;
    private Thread monitorThread;
    private Monitor[] monitors = new Monitor[4];

    public WebContainerMonitor(WebContainerManager manager, ContainerMonitorDescriptor desc, Hashtable ctxGroups, ClassLoadManager classLoadManager, PrintStream sysout, PrintStream syserr, String engineName) {
        this.systemOut = sysout;
        this.systemErr = syserr;
        this.desc = desc;
        this.engineName = engineName;
        this.running = false;
        this.destroyed = false;
        this.monitors[0] = new ThreadPoolMonitor(ctxGroups);
        this.monitors[2] = new SessionMonitor(ctxGroups);
        this.monitors[3] = classLoadManager;
        this.monitors[1] = new ContextGroupMonitor(manager, ctxGroups, this.systemOut, this.systemErr);
    }

    private void setPeriods() {
        this.monitors[0].setPeriod(this.desc.getThreadPoolCheckPeriod() / 1000L);
        this.monitors[2].setPeriod(this.desc.getSessionCheckPeriod() / 1000L);
        this.monitors[3].setPeriod(this.desc.getServletReloadCheckPeriod() / 1000L);
        this.monitors[1].setPeriod(300000L / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor() {
        this.setPeriods();
        WebContainerMonitor webContainerMonitor = this;
        synchronized (webContainerMonitor) {
            if (!this.destroyed && !this.running && this.desc.isEnable()) {
                this.monitorThread = new Thread(this);
                this.monitorThread.setName(this.engineName + ".ContainerMonitor");
                this.monitorThread.setDaemon(true);
                this.running = true;
                this.monitorThread.start();
            } else if (this.monitorThread != null) {
                this.monitorThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        WebContainerMonitor webContainerMonitor = this;
        synchronized (webContainerMonitor) {
            this.destroyed = true;
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int size = this.monitors.length;
        this.currentTime = 0L;
        while (this.running && this.monitorThread != null && this.desc.isEnable()) {
            long sleepTime = Long.MAX_VALUE;
            long nextInvokeTime = 0L;
            for (int i = 0; i < size; ++i) {
                if (this.monitors[i] == null) continue;
                try {
                    nextInvokeTime = this.monitors[i].doMonitor(this.currentTime);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                    nextInvokeTime = -1L;
                }
                if (nextInvokeTime <= 0L || nextInvokeTime >= sleepTime) continue;
                sleepTime = nextInvokeTime;
            }
            if (sleepTime == Long.MAX_VALUE) break;
            sleepTime -= this.currentTime;
            try {
                Thread.sleep(sleepTime * 1000L);
            }
            catch (InterruptedException e) {
                WebContainerMonitor webContainerMonitor = this;
                synchronized (webContainerMonitor) {
                    WebContainerMonitor webContainerMonitor2 = this;
                    webContainerMonitor2.monitorThread.interrupted();
                }
            }
            this.currentTime += sleepTime;
        }
        this.running = false;
    }
}

