/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import jeus.servlet.connection.Connector;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.Ajp13RequestProcessor;
import jeus.servlet.engine.Ajp13ThreadPoolManager;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;
import jeus.servlet.util.SimpleTimer;
import jeus.util.message.JeusMessage_WebContainer1;
import jeus.util.net.PipeServerSocket;
import jeus.util.net.PipeSocket;

public class Ajp13Connector
extends Connector {
    private boolean running = true;
    private ServerSocket serverSocket;
    private Ajp13PipeConnector pipeConnector;
    private int retryInterval = 1;
    private Ajp13ThreadPoolManager poolManager;

    public Ajp13Connector(ContextGroup ctxGroup, ConnectionDescriptor desc) {
        super(ctxGroup, desc);
        this.poolManager = new Ajp13ThreadPoolManager(ctxGroup, desc);
    }

    public void init() throws StartingException {
        try {
            this.poolManager.createPool();
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_WebContainer1._2050_LEVEL)) {
                logger.log(JeusMessage_WebContainer1._2050_LEVEL, JeusMessage_WebContainer1._2050, (Object)this.listenerId, (Throwable)e);
            }
            throw new StartingException(JeusMessage_WebContainer1._2050, this.listenerId, (Throwable)e);
        }
    }

    public void startConnector() throws StartingException {
        Exception socketEx = null;
        Exception pipeEx = null;
        boolean socketOK = false;
        boolean pipeOK = false;
        if (this.port > 0) {
            block6: {
                try {
                    this.serverSocket = new ServerSocket(this.port, this.backlog);
                }
                catch (Exception e) {
                    socketEx = e;
                    if (!logger.isLoggable(JeusMessage_WebContainer1._2051_LEVEL)) break block6;
                    logger.log(JeusMessage_WebContainer1._2051_LEVEL, JeusMessage_WebContainer1._2051, (Object[])new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)e);
                }
            }
            if (socketEx == null) {
                Thread listener = new Thread(this);
                listener.setName(this.listenerId + "-acceptor");
                listener.start();
                socketOK = true;
                if (logger.isLoggable(JeusMessage_WebContainer1._2052_LEVEL)) {
                    logger.log(JeusMessage_WebContainer1._2052_LEVEL, JeusMessage_WebContainer1._2052, (Object[])new String[]{this.listenerId, String.valueOf(this.port)});
                }
            }
        }
        if (!pipeOK && !socketOK) {
            throw new StartingException(JeusMessage_WebContainer1._2051, new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)(socketEx == null ? pipeEx : socketEx));
        }
    }

    public void run() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                this.retryInterval = 1;
                Ajp13RequestProcessor proc = this.poolManager.getProcessor();
                if (proc == null) {
                    if (logger.isLoggable(JeusMessage_WebContainer1._2080_LEVEL)) {
                        logger.log(JeusMessage_WebContainer1._2080_LEVEL, JeusMessage_WebContainer1._2080);
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException se) {
                    se.printStackTrace();
                }
                try {
                    proc.startWorking(socket);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(JeusMessage_WebContainer1._2088_LEVEL)) {
                        logger.log(JeusMessage_WebContainer1._2088_LEVEL, JeusMessage_WebContainer1._2088, (Object)this.listenerId);
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                    }
                }
            }
            catch (InterruptedIOException iioe) {
            }
            catch (SocketException se) {
                if (!this.running || !logger.isLoggable(JeusMessage_WebContainer1._2081_LEVEL)) continue;
                logger.log(JeusMessage_WebContainer1._2081_LEVEL, JeusMessage_WebContainer1._2081, (Object[])new String[]{this.listenerId, String.valueOf(this.poolManager.getCurrentThreadNum())}, (Throwable)se);
            }
            catch (Exception e) {
                if (!this.running) continue;
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (logger.isLoggable(JeusMessage_WebContainer1._2055_LEVEL)) {
                    logger.log(JeusMessage_WebContainer1._2055_LEVEL, JeusMessage_WebContainer1._2055, (Object)this.listenerId, (Throwable)e);
                }
                try {
                    Thread.sleep(this.retryInterval * 1000);
                }
                catch (Exception e3) {
                    // empty catch block
                }
                this.retryInterval *= 2;
                try {
                    this.serverSocket = new ServerSocket(this.port, this.backlog);
                }
                catch (Exception e3) {
                    if (logger.isLoggable(JeusMessage_WebContainer1._2051_LEVEL)) {
                        logger.log(JeusMessage_WebContainer1._2051_LEVEL, JeusMessage_WebContainer1._2051, (Object[])new String[]{this.listenerId, String.valueOf(this.port)}, (Throwable)e3);
                    }
                    this.running = false;
                }
            }
        }
        if (logger.isLoggable(JeusMessage_WebContainer1._2056_LEVEL)) {
            logger.log(JeusMessage_WebContainer1._2056_LEVEL, JeusMessage_WebContainer1._2056, (Object[])new String[]{this.listenerId, String.valueOf(this.port)});
        }
    }

    public void destroy(SimpleTimer timer) {
        this.running = false;
        try {
            Socket dummy = new Socket("127.0.0.1", this.port);
            dummy.close();
            this.serverSocket.close();
            this.poolManager.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pipeConnector != null) {
            this.pipeConnector.destroy();
        }
        this.poolManager.waitWorkerDestroy(timer);
    }

    protected int[] getThreadInfo() {
        int[] info = new int[]{this.poolManager.getCurrentThreadNum(), -1, this.poolManager.getMaxThreadNum()};
        return info;
    }

    public ThreadPoolManager[] getThreadPoolManager() {
        return new ThreadPoolManager[]{this.poolManager};
    }

    public class Ajp13PipeConnector
    implements Runnable {
        private boolean running = true;
        private PipeServerSocket serverSocket;
        private int retryInterval = 1;

        Ajp13PipeConnector(PipeServerSocket pipeServerSocket) {
            this.serverSocket = pipeServerSocket;
        }

        public void run() {
            String path = this.serverSocket.getPath();
            while (this.running) {
                try {
                    PipeSocket socket = this.serverSocket.accept();
                    if (!this.running) break;
                    this.retryInterval = 1;
                    Ajp13RequestProcessor proc = Ajp13Connector.this.poolManager.getProcessor();
                    if (proc == null) {
                        if (Connector.logger.isLoggable(JeusMessage_WebContainer1._2080_LEVEL)) {
                            Connector.logger.log(JeusMessage_WebContainer1._2080_LEVEL, JeusMessage_WebContainer1._2080);
                        }
                        try {
                            socket.close();
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    try {
                        proc.startWorking((Socket)socket);
                    }
                    catch (IOException ioe) {
                        if (Connector.logger.isLoggable(JeusMessage_WebContainer1._2088_LEVEL)) {
                            Connector.logger.log(JeusMessage_WebContainer1._2088_LEVEL, JeusMessage_WebContainer1._2088, (Object)Ajp13Connector.this.listenerId);
                        }
                        try {
                            socket.close();
                        }
                        catch (Exception e) {
                        }
                    }
                }
                catch (InterruptedIOException iioe) {
                }
                catch (SocketException se) {
                    if (!this.running || !Connector.logger.isLoggable(JeusMessage_WebContainer1._2081_LEVEL)) continue;
                    Connector.logger.log(JeusMessage_WebContainer1._2081_LEVEL, JeusMessage_WebContainer1._2081, (Object[])new String[]{Ajp13Connector.this.listenerId, String.valueOf(Ajp13Connector.this.poolManager.getCurrentThreadNum())}, (Throwable)se);
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    if (this.serverSocket != null) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    if (Connector.logger.isLoggable(JeusMessage_WebContainer1._2055_LEVEL)) {
                        Connector.logger.log(JeusMessage_WebContainer1._2055_LEVEL, JeusMessage_WebContainer1._2055, (Object)Ajp13Connector.this.listenerId, (Throwable)e);
                    }
                    try {
                        Thread.sleep(this.retryInterval * 1000);
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    this.retryInterval *= 2;
                    try {
                        this.serverSocket = new PipeServerSocket(Ajp13Connector.this.listenerId, Ajp13Connector.this.backlog);
                    }
                    catch (Exception e3) {
                        if (Connector.logger.isLoggable(JeusMessage_WebContainer1._2051_LEVEL)) {
                            Connector.logger.log(JeusMessage_WebContainer1._2051_LEVEL, JeusMessage_WebContainer1._2051, (Object[])new String[]{Ajp13Connector.this.listenerId, String.valueOf(Ajp13Connector.this.port)}, (Throwable)e3);
                        }
                        this.running = false;
                    }
                }
            }
            if (Connector.logger.isLoggable(JeusMessage_WebContainer1._2056_LEVEL)) {
                Connector.logger.log(JeusMessage_WebContainer1._2056_LEVEL, JeusMessage_WebContainer1._2056, (Object[])new String[]{Ajp13Connector.this.listenerId, path});
            }
        }

        void destroy() {
            this.running = false;
            try {
                PipeSocket dummy = new PipeSocket(this.serverSocket.getPath());
                dummy.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

