/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import jeus.io.impl.StreamHandlerImpl14;
import jeus.servlet.connector.Constants;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.connector.protocol.FileMessage;
import jeus.servlet.connector.protocol.Message;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class NIOSimpleFileSavingOutputAdaptor
extends ProtocolOutputAdaptor {
    public static final String FILE_PREFIX = "tcpservletresmsg";
    private Message fileStorage = null;

    public NIOSimpleFileSavingOutputAdaptor(NIOWebServerOutputStream nioWebServerOutputStream, byte[] httpBody) {
        super(null, nioWebServerOutputStream, null, httpBody);
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    protected void writeHeader() {
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.bufferSize - this.bufferCount;
        if (freeSpace < min) {
            this.flush(true, false);
        }
        if ((freeSpace = this.bufferSize - this.bufferCount) < min) {
            throw new IOException("buffer full. min = " + min);
        }
        return freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        try {
            if (last) {
                if (this.streamHandler == null) {
                    logger.log(JeusMessage_WebContainer2._3968_LEVEL, JeusMessage_WebContainer2._3968);
                    return false;
                }
                StreamHandlerImpl14 streamHandlerImpl14 = this.streamHandler;
                synchronized (streamHandlerImpl14) {
                    boolean sendFile = this.sendFileMessage();
                    boolean sendBuffer = this.sendBufferMessage(true);
                    return sendFile || sendBuffer;
                }
            }
            if (forced) {
                this.writeMessageInFile(false);
            }
            return false;
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), (Throwable)e);
            this.committed = false;
            this.reset();
            throw new IOException(e.getMessage());
        }
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.headerCount = this.webServerHeaderSize;
        this.resetContent();
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.contentCount = 0;
        this.destroyFileStorage();
    }

    protected void finish() {
        this.destroyFileStorage();
        super.finish();
    }

    private boolean writeMessageInFile(boolean last) throws Exception {
        if (this.bufferCount > this.webServerHeaderSize) {
            this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
            if (this.bufferCount > 0) {
                int fileLength;
                if (this.fileStorage == null) {
                    this.fileStorage = new FileMessage(FILE_PREFIX, ".tmp", Constants.FILE_PERSISTENT_MESSAGE_TEMP_DIRECTORY);
                    this.fileStorage.initialize();
                }
                if ((fileLength = this.fileStorage.getContentLength()) == -1) {
                    this.fileStorage.setContentLength(this.bufferCount);
                } else {
                    this.fileStorage.setContentLength(fileLength + this.bufferCount);
                }
                this.fileStorage.appendMessage(this.httpBody, 0, this.bufferCount);
                this.bufferCount = this.webServerHeaderSize;
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return true;
            }
        }
        return false;
    }

    private boolean sendBufferMessage(boolean last) throws IOException {
        this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
        ByteBuffer buffer = null;
        if (this.bufferCount > 0) {
            buffer = this.streamHandler.createByteBuffer(this.bufferCount);
            buffer.put(this.httpBody, 0, this.bufferCount);
            this.streamHandler.write(buffer);
            this.bufferCount = this.webServerHeaderSize;
            this.committed = true;
            if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendFileMessage() throws IOException {
        if (this.fileStorage == null) {
            return false;
        }
        int totalCount = this.fileStorage.getContentLength();
        if (totalCount < 0) {
            return false;
        }
        try {
            FileInputStream inputStream = (FileInputStream)this.fileStorage.getInputStream();
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            int sended = 0;
            FileChannel fileChannel = inputStream.getChannel();
            int allocSize = Constants.FILE_SAVING_ADAPTOR_WRITE_BLOCK_SIZE;
            do {
                ByteBuffer buffer;
                if (totalCount < allocSize) {
                    allocSize = totalCount;
                }
                if ((sended = fileChannel.read(buffer = this.streamHandler.createByteBuffer(allocSize))) == -1) {
                    break;
                }
                this.streamHandler.write(buffer);
            } while ((totalCount -= sended) > 0);
        }
        finally {
            this.fileStorage.putInputStream();
            this.destroyFileStorage();
        }
        return true;
    }

    private void destroyFileStorage() {
        if (this.fileStorage != null) {
            this.fileStorage.destroy();
            this.fileStorage = null;
        }
    }
}

