/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import jeus.servlet.connector.NIOWebServerOutputStream;
import jeus.servlet.engine.io.ProtocolOutputAdaptor;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_WebContainer2;

public class NIOSimpleFullBufferedOutputAdaptor
extends ProtocolOutputAdaptor {
    public NIOSimpleFullBufferedOutputAdaptor(NIOWebServerOutputStream nioWebServerOutputStream, byte[] httpBody) {
        super(null, nioWebServerOutputStream, null, httpBody);
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    protected void writeHeader() throws IOException {
    }

    protected int prepareBuffer(int min, int max) throws IOException {
        int freeSpace = this.httpBody.length - this.bufferCount;
        if (freeSpace < max) {
            int diff = max - freeSpace;
            int newlen = diff <= this.bufferSize ? this.httpBody.length + this.bufferSize : this.httpBody.length + diff + this.bufferSize;
            byte[] tmpBuffer = new byte[newlen];
            System.arraycopy(this.httpBody, 0, tmpBuffer, 0, this.bufferCount);
            this.httpBody = tmpBuffer;
            tmpBuffer = null;
            return this.httpBody.length - this.bufferCount;
        }
        return freeSpace;
    }

    public boolean internalFlush(boolean forced, boolean last) throws IOException {
        if (this.streamHandler == null) {
            logger.log(JeusMessage_WebContainer2._3968_LEVEL, JeusMessage_WebContainer2._3968);
            return false;
        }
        try {
            if (this.bufferCount > this.webServerHeaderSize && last) {
                this.webServer.setWebServerHeader(last, this.bufferCount, 0, this.httpBody);
                int writeTotalSize = 0;
                ByteBuffer buffer = null;
                writeTotalSize = this.bufferCount;
                buffer = this.streamHandler.createByteBuffer(writeTotalSize);
                buffer.put(this.httpBody, 0, this.bufferCount);
                this.streamHandler.write(buffer);
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return true;
            }
            if (forced) {
                this.committed = true;
                if (logger.isLoggable(JeusMessage_WebContainer2._3274_LEVEL)) {
                    logger.log(JeusMessage_WebContainer2._3274_LEVEL, JeusMessage_WebContainer2._3274, (Object[])new String[]{new String("OutputAdaptor::" + this.hashCode())}, (Throwable)new Exception("servlet response committed"));
                }
                return false;
            }
        }
        catch (IOException ioe) {
            this.committed = false;
            this.reset();
            throw ioe;
        }
        return false;
    }

    protected void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.headerCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }

    protected void resetContent() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer2._3452));
        }
        this.bufferCount = this.webServerHeaderSize;
        this.contentCount = 0;
    }
}

