/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import jeus.io.handler.StreamContentBufferWrapper;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentWriter;
import jeus.io.handler.StreamContentWriterWrapper;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.servlet.connector.WebStreamContentWriter;
import jeus.util.JeusBootstrapPropertyValues;

public abstract class WebContentHandlerCreator
implements StreamContentHandlerCreator {
    protected ClassLoader classloader = WebContentHandlerCreator.class.getClassLoader();
    public StreamContentBufferWrapper contentBufferWrapper = null;
    public StreamContentWriterWrapper contentWriterWrapper = null;
    protected SSLEngine sslEngine;
    private boolean direct = false;

    public WebContentHandlerCreator(ClassLoader classloader) {
        String directbuffer;
        if (classloader != null) {
            this.classloader = classloader;
        }
        if ((directbuffer = JeusBootstrapPropertyValues.getSystemProperty("jeus.servlet.nio.directbuffer")) != null) {
            this.direct = directbuffer.equals("true");
        }
    }

    public StreamContentWriter createContentWriter(int selectorType, StreamHandlerImpl endpoint) {
        WebStreamContentWriter contentWriter = new WebStreamContentWriter();
        if (this.contentWriterWrapper != null) {
            return this.contentWriterWrapper.createContentWriter(selectorType, (StreamContentWriter)contentWriter, (StreamHandler)endpoint);
        }
        return contentWriter;
    }

    public ByteBuffer createByteBuffer(int size) {
        return ByteBufferCreator.allocateByteBuffer((boolean)this.direct, (int)size, (boolean)true);
    }

    public void setStreamContentBufferWrapper(StreamContentBufferWrapper contentBufferWrapper) {
        this.contentBufferWrapper = contentBufferWrapper;
    }

    public void setStreamContentWriterWrapper(StreamContentWriterWrapper contentWriterWrapper) {
        this.contentWriterWrapper = contentWriterWrapper;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public void destroy() {
        this.classloader = null;
        this.contentBufferWrapper = null;
        this.contentWriterWrapper = null;
    }
}

