/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import jeus.io.handler.StreamContentBuffer;
import jeus.io.handler.StreamContentReader;
import jeus.io.impl.StreamHandlerImpl;
import jeus.util.logging.JeusLogger;

public abstract class WebStreamContentReader
implements StreamContentReader {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    protected StreamHandlerImpl streamHandler;
    protected StreamContentBuffer buffer;
    private AtomicBoolean closed;
    protected SSLEngine sslEngine;

    public WebStreamContentReader(StreamHandlerImpl streamHandler, StreamContentBuffer buffer) {
        this.streamHandler = streamHandler;
        this.buffer = buffer;
        this.closed = new AtomicBoolean(false);
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
        this.streamHandler.close(null);
        this.streamHandler = null;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Object getPiggybackData(byte[] data) throws IOException {
        return null;
    }

    public void eventOccurred(String event) {
    }
}

