/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import jeus.io.handler.StreamContentReceiver;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.TaskContext;
import jeus.servlet.connector.WebConnectionListener;
import jeus.servlet.connector.WebConnector;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class WebStreamContentReceiver
implements StreamContentReceiver {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private WebConnector connector;
    private TaskContext taskContext;

    public WebStreamContentReceiver(WebConnector connector) {
        this.connector = connector;
    }

    public void receiveContent(Object message, StreamHandlerImpl streamHandler, byte[] header) {
        ProcessorTask processor = this.connector.getProcessorTask();
        if (this.taskContext == null) {
            this.taskContext = new TaskContext(streamHandler, message);
        } else {
            this.taskContext.setStreamHandlerImpl(streamHandler);
            this.taskContext.setMessage(message);
        }
        processor.setTaskContext(this.taskContext);
        processor.execute();
    }

    public void receiveException(Exception exception, StreamHandlerImpl reader) {
        block5: {
            WebConnectionListener connListener;
            if (logger.isLoggable(JeusMessage_WebContainer10._10219_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10219_LEVEL, JeusMessage_WebContainer10._10219, (Object)this.getSocketInfo(reader), (Throwable)exception);
            }
            if ((connListener = this.connector.getConnectionListener()) != null) {
                Object connectionContext = null;
                try {
                    if (reader instanceof NIOStreamHandlerImpl) {
                        NIOStreamHandlerImpl nioHandler = (NIOStreamHandlerImpl)reader;
                        connectionContext = this.connector.connectionContextMap.remove(reader);
                    }
                    logger.log(JeusMessage_WebContainer10._10236_LEVEL, JeusMessage_WebContainer10._10236, new Object[]{connListener, connectionContext});
                    connListener.connectionClosed(exception, (StreamHandler)reader, connectionContext);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10418_LEVEL)) break block5;
                    logger.log(JeusMessage_WebContainer10._10418_LEVEL, JeusMessage_WebContainer10._10418, t);
                }
            }
        }
    }

    public void writeDone() {
    }

    private String getSocketInfo(StreamHandlerImpl streamHandlerImpl) {
        String socketInfo = null;
        if (streamHandlerImpl == null) {
            return socketInfo;
        }
        if (streamHandlerImpl != null && streamHandlerImpl.getSocket() != null) {
            try {
                socketInfo = streamHandlerImpl.getSocket().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return socketInfo;
    }
}

