/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector;

import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import jeus.management.j2ee.servlet.ThreadPoolStatsImpl;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.servlet.common.ThreadStateInfo;
import jeus.servlet.connector.ProcessorTask;
import jeus.servlet.connector.RequestStatistic;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.pipeline.Pipeline;
import jeus.servlet.connector.pipeline.PipelineStatistic;
import jeus.servlet.deployment.StartingException;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.engine.ContextGroup;
import jeus.servlet.engine.ThreadPoolManager;

public class WebThreadPoolManager
extends ThreadPoolManager {
    private WebConnector connector;

    public WebThreadPoolManager(WebConnector connector, ContextGroup ctxgrp, ConnectionDescriptor desc) {
        super(ctxgrp, desc);
        this.connector = connector;
        this.threadPoolId = desc.getListenerId();
    }

    public Vector getThreadState(int mode) {
        if (this.connector == null) {
            return new Vector();
        }
        ConcurrentLinkedQueue processors = this.connector.getActiveProcessorTasks();
        Vector<ThreadStateInfo> infos = new Vector<ThreadStateInfo>();
        for (Object obj : processors) {
            ProcessorTask processor;
            RequestStatistic stat;
            if (!(obj instanceof ProcessorTask) || (stat = (processor = (ProcessorTask)obj).getRequestStatistic()) == null || stat.getStringWorkerThreadID() == null) continue;
            infos.addElement(processor.getThreadState(mode));
        }
        return infos;
    }

    public int getCurrentThreadNum() {
        Pipeline pipeline = this.connector.getProcessorPipeline();
        return pipeline != null ? pipeline.getCurrentThreadCount() : 0;
    }

    public int getMaxThreadNum() {
        Pipeline pipeline = this.connector.getProcessorPipeline();
        return pipeline != null ? pipeline.getMaxThreads() : this.tpoolDesc.getMaxThreadNum();
    }

    public ThreadPoolStatsImpl updateStats(ThreadPoolStatsImpl stats) {
        Pipeline pipeline = this.connector.getProcessorPipeline();
        if (pipeline != null) {
            ((CountStatisticImpl)stats.getActiveThreadCount()).setValue((long)pipeline.getCurrentThreadsBusy());
            ((CountStatisticImpl)stats.getAllThreadCount()).setValue((long)pipeline.getCurrentThreadCount());
            ((CountStatisticImpl)stats.getMaxThreadCount()).setValue((long)pipeline.getMaxThreads());
            ((CountStatisticImpl)stats.getWaitQueueCount()).setValue(-1L);
            PipelineStatistic detail = this.connector.getPipelineStatistic();
            if (detail != null) {
                stats.setStatisticVersion(2);
                ((CountStatisticImpl)stats.getTotalConnectionCount()).setValue(detail.getCountTotalConnections());
                ((CountStatisticImpl)stats.getMaxQueueCount()).setValue((long)detail.getMaxQueue());
                ((CountStatisticImpl)stats.getCurrentQueueCount()).setValue((long)detail.getCountQueued());
                ((CountStatisticImpl)stats.getRemainQueueCount()).setValue(detail.getRemainQueue());
                ((CountStatisticImpl)stats.getPeakQueueCount()).setValue(detail.getPeakQueued());
                ((CountStatisticImpl)stats.getTotalQueueCount()).setValue(detail.getCountTotalQueued());
                ((CountStatisticImpl)stats.getDifferenceQueue1MCount()).setValue(detail.getCountQueued1MinuteAverage());
                ((CountStatisticImpl)stats.getDifferenceQueue5MCount()).setValue(detail.getCountQueued5MinuteAverage());
                ((CountStatisticImpl)stats.getDifferenceQueue15MCount()).setValue(detail.getCountQueued15MinuteAverage());
                ((CountStatisticImpl)stats.getOverflowCount()).setValue(detail.getCountOverflows());
                ((CountStatisticImpl)stats.getQueueWaitTimeAverage()).setValue((long)detail.getQueueWaitTimeAverage());
            }
        }
        return stats;
    }

    public void clearStats() {
        PipelineStatistic stat = this.connector.getPipelineStatistic();
        stat.clearStatistics();
    }

    public void destroy() {
        if (this.threadPoolMo != null) {
            this.threadPoolMo.destroyMBean();
        }
        this.connector = null;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.connector.getPipelineStatistic();
    }

    public void createPool() throws StartingException {
    }

    public int createThreads() {
        return 0;
    }

    public void checkThreadPool() {
    }

    public void deleteAllThreads() {
    }
}

