/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.pipeline;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public class JeusWebThreadFactory
implements ThreadFactory {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    private String name;
    private int port;
    private AtomicInteger threadCount = new AtomicInteger();
    private int priority;
    private static final ThreadGroup threadGroup = new ThreadGroup("JeusWeb");
    private String threadPrefix;

    public JeusWebThreadFactory(String name, int port, int priority) {
        this(name, port, priority, "");
    }

    public JeusWebThreadFactory(String name, int port, int priority, String threadPrefix) {
        this.name = name;
        this.port = port;
        this.priority = priority;
        this.threadPrefix = threadPrefix;
    }

    public Thread newThread(Runnable r) {
        Thread t = new Thread(threadGroup, r);
        t.setName(this.name + "-" + this.threadPrefix + "(" + this.port + ")-w" + this.threadCount.toString());
        t.setPriority(this.priority);
        t.setDaemon(true);
        this.threadCount.incrementAndGet();
        if (this.threadCount.get() > Integer.MAX_VALUE) {
            this.threadCount.set(0);
        }
        return t;
    }

    public ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public boolean interruptThread(long threadID) {
        return false;
    }

    public boolean interruptThread(String threadID) {
        if (threadID == null) {
            return false;
        }
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threadID.equals(threads[i].getName())) continue;
            try {
                threads[i].interrupt();
                if (logger.isLoggable(JeusMessage_WebContainer10._10003_LEVEL)) {
                    logger.log(JeusMessage_WebContainer10._10003_LEVEL, JeusMessage_WebContainer10._10003, (Object)threadID);
                }
                return true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return false;
    }
}

