/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.pipeline;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jeus.servlet.connector.MaxConnectionReachedException;
import jeus.servlet.connector.Task;
import jeus.servlet.connector.WebConnector;
import jeus.servlet.connector.pipeline.JeusWebThreadFactory;
import jeus.servlet.connector.pipeline.Pipeline;
import jeus.servlet.connector.pipeline.PipelineStatistic;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebContainer10;

public abstract class ThreadPoolExecutorPipeline
implements Pipeline,
RejectedExecutionHandler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.servlet.connector");
    protected int maxQueueSize = 4096;
    private int maxThreads = 20;
    private int minThreads = 10;
    private int port = 8080;
    private int priority = 5;
    private long threadsTimeout = 3000L;
    private boolean isStarted = false;
    protected String name;
    private ThreadPoolExecutor workerThreads;
    private PipelineStatistic pipelineStat;
    private String threadPrefix;
    protected boolean unbounded;

    public void initPipeline() throws IOException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.workerThreads = new ThreadPoolExecutor(this.minThreads, this.maxThreads, this.threadsTimeout, TimeUnit.MILLISECONDS, this.makeBlockingQueue(), new JeusWebThreadFactory(this.name, this.port, this.priority, this.threadPrefix), this);
    }

    public void startPipeline() {
    }

    public void stopPipeline() {
        if (!this.isStarted) {
            return;
        }
        if (this.workerThreads != null) {
            this.workerThreads.shutdown();
        }
        this.isStarted = false;
    }

    public void finishPipeline() {
        if (!this.isStarted) {
            this.workerThreads = null;
            this.pipelineStat = null;
        }
    }

    public void addTask(Task task) {
        if (this.pipelineStat != null) {
            this.pipelineStat.gather(this.size());
        }
        this.workerThreads.execute(task);
    }

    public Task getTask() {
        return null;
    }

    public int size() {
        return this.workerThreads.getQueue().size();
    }

    public boolean interruptThread(long threadID) {
        return ((JeusWebThreadFactory)this.workerThreads.getThreadFactory()).interruptThread(threadID);
    }

    public boolean interruptThread(String threadID) {
        return ((JeusWebThreadFactory)this.workerThreads.getThreadFactory()).interruptThread(threadID);
    }

    public int getWaitingThread() {
        return this.workerThreads.getPoolSize() - this.workerThreads.getActiveCount();
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return this.workerThreads.getPoolSize();
    }

    public int getCurrentThreadsBusy() {
        return this.workerThreads.getActiveCount();
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        int queueSize = maxQueueSize;
        if (this.unbounded) {
            queueSize = -1;
        }
        this.maxQueueSize = queueSize;
        if (this.pipelineStat != null) {
            this.pipelineStat.setQueueSize(queueSize);
        }
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public String toString() {
        return "[name=" + this.name + ", maxThreads=" + this.maxThreads + ", minThreads=" + this.minThreads + ", timeout=" + this.threadsTimeout + ", maxQueue=" + this.maxQueueSize + "]";
    }

    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (this.pipelineStat != null) {
            this.pipelineStat.gatherOverflow();
        }
        Task task = (Task)r;
        String message = ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer10._10001, (Object[])new Object[]{this.name, String.valueOf(this.maxQueueSize), String.valueOf(this.workerThreads.getQueue().size())});
        MaxConnectionReachedException mcre = new MaxConnectionReachedException(message);
        if (logger.isLoggable(JeusMessage_WebContainer10._10400_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10400_LEVEL, JeusMessage_WebContainer10._10400, (Object)message);
        }
        task.cancelTask(mcre, message);
        WebConnector connector = task.getConnector();
        if (connector != null) {
            connector.returnTask(task);
        }
    }

    public void setThreadsIncrement(int threadsIncrement) {
    }

    public void setThreadsTimeout(long threadsTimeout) {
        this.threadsTimeout = threadsTimeout;
    }

    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }

    public void setThreadPrefix(String threadPrefix) {
        this.threadPrefix = threadPrefix;
    }

    public abstract BlockingQueue makeBlockingQueue() throws IOException;
}

