/*
 * Decompiled with CFR 0.152.
 */
package jeus.servlet.connector.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jeus.servlet.connector.protocol.AbstractMessage;
import jeus.util.message.JeusMessage_WebContainer10;

public class FileMessage
extends AbstractMessage {
    private FileInputStream fileInput;
    private FileOutputStream fileOutput;
    private String prefix;
    private String suffix;
    private String directory;
    private File messageFile;
    private int messageOffset;
    private boolean complete;

    public FileMessage(String prefix, String suffix, String directory) {
        this(-1, prefix, suffix, directory);
    }

    public FileMessage(int contentLength, String prefix, String suffix) {
        this(contentLength, prefix, suffix, null);
    }

    public FileMessage(int contentLength, String prefix, String suffix, String directory) {
        this.setMessageType(2);
        this.setContentLength(contentLength);
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
    }

    public synchronized void initialize() throws IOException {
        this.complete = false;
        this.messageOffset = 0;
        File dirFile = null;
        if (this.directory != null) {
            try {
                dirFile = new File(this.directory);
            }
            catch (Exception e) {
                dirFile = null;
            }
        }
        if (dirFile != null && !dirFile.isDirectory()) {
            dirFile = null;
        }
        this.messageFile = File.createTempFile(this.prefix, this.suffix, dirFile);
        if (logger.isLoggable(JeusMessage_WebContainer10._10301_LEVEL)) {
            logger.log(JeusMessage_WebContainer10._10301_LEVEL, JeusMessage_WebContainer10._10301, (Object[])new String[]{this.messageFile.toString(), String.valueOf(this.getContentLength())});
        }
        this.messageFile.deleteOnExit();
    }

    public synchronized void destroy() {
        super.destroy();
        this.complete = false;
        this.messageOffset = 0;
        this.putInputStream();
        this.putOutputStream();
        this.messageFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getMessage() {
        this.putOutputStream();
        int contentLength = this.getContentLength();
        if (contentLength == -1) {
            return null;
        }
        byte[] message = new byte[contentLength];
        int read = 0;
        try {
            if (this.getInputStream() == null) {
                byte[] byArray = null;
                return byArray;
            }
            read = this.fileInput.read(message, 0, message.length);
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10307_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10307_LEVEL, JeusMessage_WebContainer10._10307, (Object[])new String[]{this.toString(), this.messageFile.toString()}, (Throwable)e);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.putInputStream();
        }
        this.checkContentLength(read);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMessage(byte[] message) {
        this.complete = true;
        if (message == null) {
            this.setContentLength(-1);
            this.messageOffset = 0;
            this.putInputStream();
            this.putOutputStream();
            return;
        }
        try {
            this.getOutputStream();
            this.fileOutput.write(message);
            this.fileOutput.flush();
            this.setContentLength(message.length);
            this.messageOffset = message.length;
        }
        catch (IOException e) {
            if (logger.isLoggable(JeusMessage_WebContainer10._10308_LEVEL)) {
                logger.log(JeusMessage_WebContainer10._10308_LEVEL, JeusMessage_WebContainer10._10308, (Object[])new String[]{this.toString(), this.messageFile.toString()}, (Throwable)e);
            }
            this.setContentLength(-1);
            this.messageOffset = 0;
        }
        finally {
            this.putOutputStream();
        }
    }

    public synchronized void appendMessage(byte[] appendMessage) {
        if (appendMessage == null) {
            return;
        }
        this.appendMessage(appendMessage, 0, appendMessage.length);
    }

    public void appendMessage(byte[] appendMessage, int offset, int length) {
        block8: {
            if (appendMessage == null) {
                return;
            }
            if (this.complete) {
                return;
            }
            if (offset < 0 || offset >= appendMessage.length) {
                return;
            }
            if (offset + length > appendMessage.length) {
                return;
            }
            int contentLength = this.getContentLength();
            int remain = contentLength - this.messageOffset;
            if (remain <= 0) {
                return;
            }
            int copyLen = length;
            if (remain < copyLen) {
                copyLen = remain;
            }
            try {
                this.getOutputStream();
                this.fileOutput.write(appendMessage, offset, copyLen);
                this.fileOutput.flush();
                this.messageOffset += copyLen;
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_WebContainer10._10309_LEVEL)) break block8;
                logger.log(JeusMessage_WebContainer10._10309_LEVEL, JeusMessage_WebContainer10._10309, (Object[])new String[]{this.toString(), this.messageFile.toString()}, (Throwable)e);
            }
        }
    }

    public synchronized InputStream getInputStream() throws FileNotFoundException {
        this.putOutputStream();
        int contentLength = this.getContentLength();
        if (contentLength == -1) {
            return null;
        }
        this.checkContentLength(this.messageOffset);
        if (this.fileInput != null) {
            return this.fileInput;
        }
        this.fileInput = new FileInputStream(this.messageFile);
        return this.fileInput;
    }

    public synchronized void putInputStream() {
        if (this.fileInput != null) {
            block3: {
                try {
                    this.fileInput.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10305_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer10._10305_LEVEL, JeusMessage_WebContainer10._10305, (Object[])new String[]{this.toString(), this.messageFile.toString()}, (Throwable)e);
                }
            }
            this.fileInput = null;
        }
    }

    private OutputStream getOutputStream() throws FileNotFoundException {
        if (this.fileOutput != null) {
            return this.fileOutput;
        }
        this.fileOutput = new FileOutputStream(this.messageFile);
        return this.fileOutput;
    }

    private void putOutputStream() {
        if (this.fileOutput != null) {
            block3: {
                try {
                    this.fileOutput.close();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_WebContainer10._10306_LEVEL)) break block3;
                    logger.log(JeusMessage_WebContainer10._10306_LEVEL, JeusMessage_WebContainer10._10306, (Object[])new String[]{this.toString(), this.messageFile.toString()}, (Throwable)e);
                }
            }
            this.fileOutput = null;
        }
    }

    public static void main(String[] args) {
        FileMessage myMsg = new FileMessage(10, "mymessage", ".tmp");
        try {
            myMsg.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        myMsg.setContentLength(3);
        myMsg.appendMessage("ab".getBytes());
        myMsg.appendMessage("cde".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.setMessage("098761".getBytes());
        myMsg.setMessage("1234511".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.appendMessage("alpha".getBytes());
        System.out.println("myMsg = " + new String(myMsg.getMessage()) + ",conLen = " + myMsg.getContentLength());
        myMsg.destroy();
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

